<?php

namespace App\Http\Controllers;

use App\Models\Branch;
use App\Models\BranchIntro;
use Illuminate\Http\Request;

class BranchController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $branches = Branch::get();
        return view('backend.pages.setting.depot.index',compact('branches'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.pages.setting.depot.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        Branch::create([
            'name' => $request->name,
            'name_bn' => $request->name_bn,
            'email' => $request->email,
            'phone' => $request->phone,
            'phone_bn' => $request->phone_bn,
            'address' => $request->address,
            'address_bn' => $request->address_bn,
        ]);
        session()->flash('message', 'Depot save successfully');
        return redirect('admin/branch');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Branch  $branch
     * @return \Illuminate\Http\Response
     */
    public function show(Branch $branch)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Branch  $branch
     * @return \Illuminate\Http\Response
     */
    public function edit(Branch $branch)
    {
        return view('backend.pages.setting.depot.edit',['branch'=>$branch]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Branch  $branch
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Branch $branch)
    {
        $branch->update([
            'name' => $request->name,
            'name_bn' => $request->name_bn,
            'email' => $request->email,
            'phone' => $request->phone,
            'phone_bn' => $request->phone_bn,
            'address' => $request->address,
            'address_bn' => $request->address_bn,
        ]);
        session()->flash('message', 'Depot update successfully');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Branch  $branch
     * @return \Illuminate\Http\Response
     */
    public function destroy(Branch $branch)
    {
        $branch->delete();
        session()->flash('message', 'Depot delete successfully');
        return redirect()->back();
    }

     /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function info(Request $request)
    {
        BranchIntro::where('id','>',0)->update([
            'title' => $request->title,
            'title_bn' => $request->title_bn,
            'description_bn' => $request->description_bn,
            'description' => $request->description,
            'meta_title' => $request->meta_title,
            'meta_des' => $request->meta_des,
        ]);
        session()->flash('message', 'Depot info save successfully');
        return redirect('admin/depot');
    }
}
