
<?php $__env->startSection('title'); ?>
Gallery
<?php $__env->stopSection(); ?>
<?php
    $company = App\Models\Company::first();
?>
<?php $__env->startSection('meta'); ?>
    <meta name="title" content="<?php echo e($company->meta_title); ?>">
    <meta name="description" content="<?php echo e($company->meta_des); ?>">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">
    <meta property="og:title" content="<?php echo e($company->meta_title); ?>">
    <meta property="og:description" content="<?php echo e($company->meta_des); ?>">
    <meta property="og:image" content="<?php echo e(asset('public')); ?>/<?php echo e($company->logo); ?>">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?php echo e(url()->current()); ?>">
    <meta property="twitter:title" content="<?php echo e($company->meta_title); ?>">
    <meta property="twitter:description" content="<?php echo e($company->meta_des); ?>">
    <meta property="twitter:image" content="<?php echo e(asset('public')); ?>/<?php echo e($company->logo); ?>">

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<?php
    $galleries = App\Models\Gallery::get();
?>
 <!-- Page Header Section Start Here -->
 <section class="page-header bg_img padding-tb">
    <div class="overlay"></div>
    <div class="container">
        <div class="page-header-content-area">
            <h4 class="ph-title"><?php if(session()->get('lang') == 'en'): ?> Gallery <?php else: ?> ছবি <?php endif; ?></h4>
            <ul class="agri-ul">
                <li><a href="/"><?php if(session()->get('lang') == 'en'): ?> Home <?php else: ?> হোম <?php endif; ?></a></li>
                <li><a class="active"><?php if(session()->get('lang') == 'en'): ?> Gallery <?php else: ?> ছবি <?php endif; ?></a></li>
            </ul>
        </div>
    </div>
</section>
<!-- Page Header Section Ending Here -->

<!-- product section start here -->
<div class="product-section grid-2 padding-tb">
    <div class="container">
        <div class="section-wrapper">
            <div class="row justify-content-center">
                <?php $__currentLoopData = $galleries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-6 col-12">
                    <div class="product-item">
                        <div class="product-inner">
                            <div class="product-thumb">
                                <img src="<?php echo e(asset('public')); ?>/<?php echo e($gallery->image); ?>" alt="product">
                            </div>
                            <div class="product-content">
                                <a href="<?php echo e(asset('public')); ?>/<?php echo e($gallery->image); ?>" data-rel="lightcase" class="product-name"><?php if(session()->get('lang') == 'en'): ?> <?php echo e($gallery->title); ?> <?php else: ?> <?php echo e($gallery->title_bn); ?> <?php endif; ?></a>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</div>
<!-- product section ending here -->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\ewclold\resources\views/frontend/pages/gallery/index.blade.php ENDPATH**/ ?>