
<?php $__env->startSection('title'); ?>
Mission Visions
<?php $__env->stopSection(); ?>
<?php
    $data = App\Models\MissionVisions::first();
?>
<?php $__env->startSection('meta'); ?>
    <meta name="title" content="<?php echo e($data->meta_title); ?>">
    <meta name="description" content="<?php echo e($data->meta_des); ?>">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">
    <meta property="og:title" content="<?php echo e($data->meta_title); ?>">
    <meta property="og:description" content="<?php echo e($data->meta_des); ?>">
    <meta property="og:image" content="<?php echo e(asset('public')); ?>/<?php echo e($data->image); ?>">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?php echo e(url()->current()); ?>">
    <meta property="twitter:title" content="<?php echo e($data->meta_title); ?>">
    <meta property="twitter:description" content="<?php echo e($data->meta_des); ?>">
    <meta property="twitter:image" content="<?php echo e(asset('public')); ?>/<?php echo e($data->image); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

 <!-- Page Header Section Start Here -->
 <section class="page-header bg_img padding-tb">
    <div class="overlay"></div>
    <div class="container">
        <div class="page-header-content-area">
            <h4 class="ph-title"><?php if(session()->get('lang') == 'en'): ?> Mission & Visions <?php else: ?> মিশন ও ভিশন <?php endif; ?></h4>
            <ul class="agri-ul">
                <li><a href="/"><?php if(session()->get('lang') == 'en'): ?> Home <?php else: ?> হোম <?php endif; ?></a></li>
                <li><a class="active"><?php if(session()->get('lang') == 'en'): ?> Mission & Visions <?php else: ?> মিশন ও ভিশন <?php endif; ?></a></li>
            </ul>
        </div>
    </div>
</section>
<!-- Page Header Section Ending Here -->

<div class="blog-section blog-single padding-tb">
    <div class="container">
        <div class="section-wrapper">
            <div class="row justify-content-center">
                <div class="col-lg-6 col-md-8 col-12">
                    <article>
                        <div class="post-item-2">
                            <div class="post-inner">
                                <div class="post-thumb">
                                    <img src="<?php echo e(asset('public')); ?>/<?php echo e($data->image); ?>" alt="Mission & Vission" class="br-5">
                                </div>
                            </div>
                        </div>
                    </article>
                </div>
                <div class="col-lg-6 col-md-8 col-12">
                    <article>
                        <div class="post-item-2">
                            <div class="post-inner">
                                <div class="post-content">
                                    <h4><?php if(session()->get('lang') == 'en'): ?> <?php echo e($data->title); ?> <?php else: ?> <?php echo e($data->title_bn); ?> <?php endif; ?></h4>
                                    <?php if(session()->get('lang') == 'en'): ?> <?php echo $data->vision; ?> <?php else: ?> <?php echo $data->vision_bn; ?> <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </article>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\ewclold\resources\views/frontend/pages/mission_visions/index.blade.php ENDPATH**/ ?>