
<?php $__env->startSection('title'); ?>
Contact Us
<?php $__env->stopSection(); ?>
<?php
    $company = App\Models\Company::first();
?>
<?php $__env->startSection('meta'); ?>
    <meta name="title" content="<?php echo e($company->meta_title); ?>">
    <meta name="description" content="<?php echo e($company->meta_des); ?>">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">
    <meta property="og:title" content="<?php echo e($company->meta_title); ?>">
    <meta property="og:description" content="<?php echo e($company->meta_des); ?>">
    <meta property="og:image" content="<?php echo e(asset('public')); ?>/<?php echo e($company->logo); ?>">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?php echo e(url()->current()); ?>">
    <meta property="twitter:title" content="<?php echo e($company->meta_title); ?>">
    <meta property="twitter:description" content="<?php echo e($company->meta_des); ?>">
    <meta property="twitter:image" content="<?php echo e(asset('public')); ?>/<?php echo e($company->logo); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

 <!-- Page Header Section Start Here -->
 <section class="page-header bg_img padding-tb">
    <div class="overlay"></div>
    <div class="container">
        <div class="page-header-content-area">
            <h4 class="ph-title"><?php if(session()->get('lang') == 'en'): ?> Contact <?php else: ?> যোগাযোগ <?php endif; ?></h4>
            <ul class="agri-ul">
                <li><a href="/"><?php if(session()->get('lang') == 'en'): ?> Home <?php else: ?> হোম <?php endif; ?></a></li>
                <li><a class="active"><?php if(session()->get('lang') == 'en'): ?> Contact <?php else: ?> যোগাযোগ <?php endif; ?></a></li>
            </ul>
        </div>
    </div>
</section>
<!-- Page Header Section Ending Here -->

<div class="contact-section padding-tb">
    <div class="container">
        <div class="contac-top">
            <div class="row justify-content-center">
                <div class="col-xl-4 col-lg-6 col-12">
                    <div class="contact-item">
                        <div class="contact-icon">
                            <i class="icofont-google-map"></i>
                        </div>
                        <div class="contact-details">
                            <p><?php if(session()->get('lang') == 'en'): ?> <?php echo e($company->address); ?> <?php else: ?> <?php echo e($company->address_bn); ?> <?php endif; ?></p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-6 col-12">
                    <div class="contact-item">
                        <div class="contact-icon">
                            <i class="icofont-phone"></i>
                        </div>
                        <div class="contact-details">
                            <p><?php if(session()->get('lang') == 'en'): ?> <?php echo e($company->phone); ?> <?php else: ?> <?php echo e($company->phone_bn); ?> <?php endif; ?></p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-6 col-12">
                    <div class="contact-item">
                        <div class="contact-icon">
                            <i class="icofont-envelope"></i>
                        </div>
                        <div class="contact-details">
                            <p><?php echo e($company->email); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="contac-bottom">
            
            <?php if(session()->has('message')): ?>
                <div class="alert alert-success" role="alert">
                    <?php echo e(session()->get('message')); ?>

                </div>
            <?php endif; ?>
            <div class="row justify-content-center">
                <div class="col-lg-6 col-12">
                    <div class="location-map">
                        <div id="map">
                            <iframe src="<?php echo e($company->google_maps); ?>" allowfullscreen=""></iframe>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-12">
                    <div class="contact-form">
                        <form action="/message-send" method="POST" id="commentform" class="comment-form">
                            <?php echo csrf_field(); ?>
                            <input type="text" name="name" class="" placeholder="Name*" required>
                            <input type="text" name="number" class="" placeholder="Number*" required>
                            <input type="email" name="email" class="" placeholder="Email*" required>
                            <input type="text" name="subject" class="" placeholder="Subject*" required>
                            <textarea id="role" name="message" cols="30" rows="10" placeholder="Message*" required></textarea>
                            <button type="submit" class="lab-btn">
                                <span>Submit Now</span>
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\ewclold\resources\views/frontend/pages/contact/index.blade.php ENDPATH**/ ?>