
<?php $__env->startSection('title'); ?>
Depot
<?php $__env->stopSection(); ?>
<?php
    $branchs = App\Models\Branch::all();
    $branchInfo = App\Models\BranchIntro::first();
?>
<?php $__env->startSection('meta'); ?>
    <meta name="title" content="<?php echo e($branchInfo->meta_title); ?>">
    <meta name="description" content="<?php echo e($branchInfo->meta_des); ?>">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">
    <meta property="og:title" content="<?php echo e($branchInfo->meta_title); ?>">
    <meta property="og:description" content="<?php echo e($branchInfo->meta_des); ?>">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?php echo e(url()->current()); ?>">
    <meta property="twitter:title" content="<?php echo e($branchInfo->meta_title); ?>">
    <meta property="twitter:description" content="<?php echo e($branchInfo->meta_des); ?>">

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

 <!-- Page Header Section Start Here -->
 <section class="page-header bg_img padding-tb">
    <div class="overlay"></div>
    <div class="container">
        <div class="page-header-content-area">
            <h4 class="ph-title"><?php if(session()->get('lang') == 'en'): ?> Depot <?php else: ?> ডিপো <?php endif; ?></h4>
            <ul class="agri-ul">
                <li><a href="/"><?php if(session()->get('lang') == 'en'): ?> Home <?php else: ?> হোম <?php endif; ?></a></li>
                <li><a class="active"><?php if(session()->get('lang') == 'en'): ?> Depot <?php else: ?> ডিপো <?php endif; ?></a></li>
            </ul>
        </div>
    </div>
</section>
<!-- Page Header Section Ending Here -->

<!-- Service Section Start Here -->
<section class="service-section padding-tb">
    <div class="container">
        <div class="section-header">
            <h3><?php if(session()->get('lang') == 'en'): ?> <?php echo e($branchInfo->title); ?> <?php else: ?> <?php echo e($branchInfo->title_bn); ?> <?php endif; ?></h3>
        </div>
        <div class="section-wrapper">
            <div class="row justify-content-center">
                <?php $__currentLoopData = $branchs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-4 col-md-6 col-12">
                    <div class="lab-item">
                        <div class="lab-inner">
                            <div class="lab-content">
                                <h5><?php if(session()->get('lang') == 'en'): ?> <?php echo e($branch->name); ?> <?php else: ?> <?php echo e($branch->name_bn); ?>  <?php endif; ?></h5>
                                <p><strong><?php if(session()->get('lang') == 'en'): ?> Address: <?php else: ?> ঠিকানা: <?php endif; ?></strong> <?php if(session()->get('lang') == 'en'): ?> <?php echo e($branch->address); ?> <?php else: ?> <?php echo e($branch->address_bn); ?>  <?php endif; ?> </p>
                                <p><strong><?php if(session()->get('lang') == 'en'): ?> CALL: <?php else: ?> ফোন :<?php endif; ?></strong> <?php if(session()->get('lang') == 'en'): ?> <?php echo e($branch->phone); ?> <?php else: ?> <?php echo e($branch->phone_bn); ?>  <?php endif; ?></p>
                                <p><strong><?php if(session()->get('lang') == 'en'): ?> E-Mail: <?php else: ?> ইমেল: <?php endif; ?></strong> <?php echo e($branch->email); ?> </p>
                                
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\ewclold\resources\views/frontend/pages/depot/index.blade.php ENDPATH**/ ?>