<?php
    $company = App\Models\Company::first();
    $about = App\Models\AboutUs::first();
    $socialMedia = App\Models\SocialMedia::first();
?>
<footer class="footer-section padding-tb pb-0">
    <div class="container">
        <div class="footer-top">
            <div class="row">
                <div class="col-xl-3 col-md-6 col-12">
                    <div class="footer-item">
                        <div class="footer-inner">
                            <div class="footer-logo">
                                <img src="<?php echo e(asset('public')); ?>/<?php echo e($company->logo); ?>" alt="footer-logo">
                            </div>
                            <div class="footer-desc">
                                <p><?php if(session()->get('lang') == 'en'): ?> <?php echo Str::limit($about->short_description, 250); ?> <?php else: ?> <?php echo Str::limit($about->short_description_bn, 250); ?> <?php endif; ?></p>
                            </div>
                            <div class="ht-right">
								<div class="scocial-media">
									<a href="<?php echo e($socialMedia->facebook); ?>" target="_blank" class="facebook"><i class="icofont-facebook"></i></a>
									<a href="<?php echo e($socialMedia->twitter); ?>" target="_blank" class="twitter"><i class="icofont-twitter"></i></a>
									<a href="<?php echo e($socialMedia->linked_in); ?>" target="_blank" class="linkedin"><i class="icofont-linkedin"></i></a>
									<a href="<?php echo e($socialMedia->instragram); ?>" target="_blank" class="instragram"><i class="icofont-vimeo"></i></a>
									<a href="<?php echo e($socialMedia->youtube); ?>" target="_blank" class="youtube"><i class="icofont-youtube"></i></a>
								</div>
							</div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6 col-12">
                    <div class="footer-item footer-addtess">
                        <div class="footer-inner">
                            <div class="footer-title">
                                <h5><?php if(session()->get('lang') == 'en'): ?> Keep In Touch <?php else: ?> যোগাযোগ <?php endif; ?> </h5>
                            </div>
                            <div class="footer-body">
                                <ul class="agri-ul">
                                    <li>
                                        <div class="icon">
                                            <i class="icofont-google-map"></i>
                                        </div>
                                        <div class="detalis">
                                            <p><?php if(session()->get('lang') == 'en'): ?> <?php echo e($company->address); ?> <?php else: ?> <?php echo e($company->address_bn); ?> <?php endif; ?></p>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="icon">
                                            <i class="icofont-phone"></i>
                                        </div>
                                        <div class="detalis">
                                            <p><?php if(session()->get('lang') == 'en'): ?> <?php echo e($company->phone); ?> <?php else: ?> <?php echo e($company->phone_bn); ?> <?php endif; ?></p>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="icon">
                                            <i class="icofont-envelope"></i>
                                        </div>
                                        <div class="detalis">
                                            <p><?php echo e($company->email); ?></p>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6 col-12">
                    <div class="footer-item footer-addtess">
                        <div class="footer-inner">
                            <div class="footer-title">
                                <h5><?php if(session()->get('lang') == 'en'): ?> About <?php else: ?> আমাদের সম্পর্কে <?php endif; ?></a></h5>
                            </div>
                            <div class="footer-body">
                                <ul class="agri-ul">
                                    <li><a href="/about-us"><?php if(session()->get('lang') == 'en'): ?> About Us <?php else: ?> আমাদের সম্পর্কে <?php endif; ?></a></li>
                                    <li><a href="/founder-speech"><?php if(session()->get('lang') == 'en'): ?> Founder Speech <?php else: ?> প্রতিষ্ঠাতা বক্তব্য <?php endif; ?></a></li>
                                    <li><a href="/mission-visions"><?php if(session()->get('lang') == 'en'): ?> Mission & Visions <?php else: ?> মিশন ও ভিশন <?php endif; ?></a></li>
                                    <li><a href="/team"><?php if(session()->get('lang') == 'en'): ?> Our Team <?php else: ?> আমাদের টীম <?php endif; ?></a></li>
                                    <li><a href="/sister-concern"><?php if(session()->get('lang') == 'en'): ?> Our Sister Concern <?php else: ?> আমাদের সহপ্রতিষ্ঠান <?php endif; ?></a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6 col-12">
                    <div class="footer-item footer-addtess">
                        <div class="footer-inner">
                            <div class="footer-title">
                                <h5><?php if(session()->get('lang') == 'en'): ?> Products <?php else: ?> পণ্য <?php endif; ?></h5>
                            </div>
                            <div class="footer-body">
                                <ul class="agri-ul">
                                    <?php $__currentLoopData = App\Models\Category::limit(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><a href="/category/<?php echo e($category->slug); ?>"> <?php if(session()->get('lang') == 'en'): ?> <?php echo e($category->name); ?> <?php else: ?> <?php echo e($category->name_bn); ?> <?php endif; ?></a></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer-bottom">
            <p>&copy; <?php echo e(date('Y')); ?><a href="/" target="_blank"><span><?php if(session()->get('lang') == 'en'): ?> <?php echo e($company->name); ?> <?php else: ?> <?php echo e($company->name_bn); ?> <?php endif; ?></span></a> <?php if(session()->get('lang') == 'en'): ?> All Rights Reserved. <?php else: ?> সর্বস্বত্ব সংরক্ষিত.  <?php endif; ?><a href="https://insideitbd.com" target="_blank"><span> </span></a></p>
        </div>
    </div>
</footer><?php /**PATH /home/axesba/public_html/daral/resources/views/frontend/includes/footer.blade.php ENDPATH**/ ?>