
<?php $__env->startSection('title'); ?> Home <?php $__env->stopSection(); ?>

<?php $__env->startSection('meta'); ?>
    <?php
        $company = App\Models\Company::first();
    ?>
    <meta name="title" content="<?php echo e($company->meta_title); ?>">
    <meta name="description" content="<?php echo e($company->meta_des); ?>">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">
    <meta property="og:title" content="<?php echo e($company->meta_title); ?>">
    <meta property="og:description" content="<?php echo e($company->meta_des); ?>">
    <meta property="og:image" content="<?php echo e(asset('public')); ?>/<?php echo e($company->logo); ?>">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?php echo e(url()->current()); ?>">
    <meta property="twitter:title" content="<?php echo e($company->meta_title); ?>">
    <meta property="twitter:description" content="<?php echo e($company->meta_des); ?>">
    <meta property="twitter:image" content="<?php echo e(asset('public')); ?>/<?php echo e($company->logo); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('head'); ?>
    <style>
        .agricul-farm-section .section-wrapper .farm-left .agricul-farm-animate .farm-line:nth-child(1) {
            top: 48%;
            right: 58%;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('header-class'); ?> transparent-header <?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php echo $__env->make('frontend.pages.home.slider', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<section class="feature-section padding-tb">
    
    <div class="container">
        <div class="section-header wow fadeInUp" data-wow-delay="0.3s">
            <h3><?php if(session()->get('lang') == 'en'): ?> Agriculture Product <?php else: ?> কৃষি পণ্য <?php endif; ?></h3>
        </div>
        <div class="section-wrapper">
            <div class="row">
                <?php $__currentLoopData = App\Models\Category::limit(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-4 col-md-6 col-12 wow fadeInUp" data-wow-delay="0.4s">
                        <div class="feature-item">
                            <div class="feature-inner">
                                <div class="feature-thumb">
                                    <img src="<?php echo e($category->image); ?>" alt="feature">
                                </div>
                                <div class="feature-content">
                                    <a href="/category/<?php echo e($category->slug); ?>"><h5><?php if(session()->get('lang') == 'en'): ?> <?php echo e($category->name); ?> <?php else: ?> <?php echo e($category->name_bn); ?> <?php endif; ?></h5></a>
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</section>
<!-- Feature Secton ending Here -->

<!-- about section start here -->
<section class="about-us bg_img_1 bg_img padding-tb">
    <?php
        $about = App\Models\AboutUs::first();
    ?>
    <div class="shape-about d-none d-xl-block">
        <img src="<?php echo e(asset('public')); ?>//assets/images/about/02.png" alt="abs-thumb">
    </div>
    <div class="container">
        <div class="row">
            <div class="col-lg-6 col-12">
                <div class="about-thumb ml-about-thumb wow fadeInUp" data-wow-delay="0.4s">
                    <img src="<?php echo e(asset('public')); ?>/<?php echo e($about->image); ?>" alt="about-thumb" class="br-5">
                </div>
            </div>
            <div class="col-lg-6 col-12">
                <div class="section-header text-start wow fadeInUp" data-wow-delay="0.3s">
                    <h3><?php if(session()->get('lang') == 'en'): ?> <?php echo e($about->title); ?> <?php else: ?> <?php echo e($about->title_bn); ?> <?php endif; ?></h3>
                    <p><?php if(session()->get('lang') == 'en'): ?> <?php echo Str::limit($about->description, 3000); ?> <?php else: ?> <?php echo Str::limit($about->description_bn, 3000); ?> <?php endif; ?></p>
                </div>
                <div class="text-start wow fadeInUp <?php if(session()->get('lang') == 'en'): ?> mt-5 <?php else: ?> mt1 <?php endif; ?>" data-wow-delay="0.6s">
                    <a href="/about-us" class="lab-btn"><span><?php if(session()->get('lang') == 'en'): ?> About Us <?php else: ?> আমাদের সম্পর্কে <?php endif; ?></span></a>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- about section ending here -->



<!-- agricul farm section start here -->
<section class="agricul-farm-section padding-tb bg_img_1 bg_img ">
    <?php
        $branchInfo = App\Models\BranchIntro::first();
    ?>
    <div class="container">
        <div class="section-wrapper">
            <div class="row">
                <div class="col-lg-7 col-12 wow fadeInUp" data-wow-delay="0.3s">
                    <div class="farm-left">
                        <div class="agricul-farm-thumb">
                            <img src="<?php echo e(asset('public/frontend')); ?>/assets/images/farm/depotmap.png" alt="agricul-farm">
                        </div>
                        <div class="agricul-farm-animate">
                            <div class="farm-line">
                                <div class="lab-tooltip"><p><?php if(session()->get('lang') == 'en'): ?> Bangladesh <?php else: ?> প্রধান কার্যালয় <?php endif; ?></p></div>
                                <span class="pluse_1"></span><span class="pluse_2"></span>
                            </div>
                        </div>
                        
                      
                    </div>
                </div>
                <div class="col-lg-5 col-12 wow fadeInUp" data-wow-delay="0.4s">
                    <div class="farm-right" style="margin-top:150px;">
                        <div class="section-header text-center text-lg-start">
                            <h3><?php if(session()->get('lang') == 'en'): ?> <?php echo e($branchInfo->title); ?> <?php else: ?> <?php echo e($branchInfo->title_bn); ?> <?php endif; ?></h3>
                            <p><?php if(session()->get('lang') == 'en'): ?> <?php echo $branchInfo->description; ?> <?php else: ?> <?php echo $branchInfo->description_bn; ?> <?php endif; ?></p>
                            <a href="/depot" class="lab-btn"><span><?php if(session()->get('lang') == 'en'): ?> Get All Branch <?php else: ?>  সকল ডিপো <?php endif; ?></span></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- agricul farm section ending here -->

<!-- team member section start here -->
<section class="team-member-section padding-tb">
    <div class="container">
        <div class="section-header wow fadeInUp" data-wow-delay="0.3s">
            <h3><?php if(session()->get('lang') == 'en'): ?> Our Team <?php else: ?> আমাদের টিম <?php endif; ?> </h3>
        </div>
        <div class="section-wrapper">
            <div class="row">
                <?php $__currentLoopData = App\Models\Team::limit(4); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $team): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-3 col-lg-4 col-sm-6 col-12 wow fadeInUp" data-wow-delay="0.4s" >
                        <div class="team-item">
                            <div class="team-inner">
                                <div class="team-thumb">
                                    <img src="<?php echo e(asset('public')); ?>/<?php echo e($team->image); ?>" alt="team-image">
                                </div>
                                <div class="team-content">
                                    <a href="#"><h6><?php if(session()->get('lang') == 'en'): ?> <?php echo e($team->name); ?> <?php else: ?> <?php echo e($team->name_bn); ?> <?php endif; ?></h6></a>
                                    <p><?php if(session()->get('lang') == 'en'): ?> <?php echo e($team->designation); ?> <?php else: ?> <?php echo e($team->designation_bn); ?> <?php endif; ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</section>
<!-- team member section ending here -->

<!-- blog section start here -->
<!--<section class="blog-section padding-tb bg_img_1 bg_img">-->
<!--    <div class="container">-->
<!--        <div class="section-header wow fadeInUp" data-wow-delay="0.3s">-->
<!--            <h3><?php if(session()->get('lang') == 'en'): ?> Blog <?php else: ?> ব্লগ <?php endif; ?></h3>-->
<!--        </div>-->
<!--        <div class="section-wrapper">-->
<!--            <div class="row justify-content-center">-->
<!--                <?php $__currentLoopData = App\Models\Blog::limit(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
<!--                <div class="col-xl-4 col-md-6 col-12 wow fadeInUp" data-wow-delay="0.4s">-->
<!--                    <div class="post-item">-->
<!--                        <div class="post-inner">-->
<!--                            <div class="post-thumb">-->
<!--                                <a href="/blogs/<?php echo e($blog->slug); ?>">-->
<!--                                    <img src="<?php echo e(asset('public')); ?>/<?php echo e($blog->image); ?>" alt="blog">-->
<!--                                </a>-->
<!--                                <div class="meta-date">-->
<!--                                    <div class="md-pre">-->
<!--                                        <p><?php echo e($blog->created_at->format('d')); ?> <?php echo e($blog->created_at->format('F')); ?>,  <?php echo e($blog->created_at->format('Y')); ?></p>-->
<!--                                    </div>-->
<!--                                </div>-->
<!--                            </div>-->
<!--                            <div class="post-content">-->
<!--                                <a href="/blogs/<?php echo e($blog->slug); ?>"><h5><?php if(session()->get('lang') == 'en'): ?> <?php echo e($blog->title); ?> <?php else: ?> <?php echo e($blog->title_bn); ?> <?php endif; ?></h5></a>-->
<!--                                <div class="text-btn">-->
<!--                                    <a href="/blogs/<?php echo e($blog->slug); ?>"><?php if(session()->get('lang') == 'en'): ?> Read More <?php else: ?> আরও পড়ুন <?php endif; ?></a>-->
<!--                                </div>   -->
<!--                            </div>-->
<!--                        </div>-->
<!--                    </div>-->
<!--                </div>-->
<!--                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
<!--            </div>-->
<!--        </div>-->
<!--    </div>-->
<!--</section>-->
<!-- sponsor section start here -->
<div class="sponsor-section padding-tb">
    <div class="container">
        <div class="section-header wow fadeInUp" data-wow-delay="0.3s">
            <h3><?php if(session()->get('lang') == 'en'): ?> Our Sister Concern <?php else: ?> আমাদের সহপ্রতিষ্ঠান <?php endif; ?></h3>
        </div>
        <div class="section-wrapper wow fadeInUp" data-wow-delay="0.4s">
            <div class="sponsor-slider">
                <div class="swiper-wrapper">
                    <?php $__currentLoopData = App\Models\SisterConcern::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $concern): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="swiper-slide">
                        <div class="sponsor-item">
                            <div class="sponsor-thumb">
                                <a href="<?php echo e($concern->link); ?>" target="_blank"><img src="<?php echo e(asset('public')); ?>/<?php echo e($concern->logo); ?>" alt="sister-concern"></a>
                                
                                    <br>
                                    <a href="<?php echo e($concern->link); ?>"><p><?php if(session()->get('lang') == 'en'): ?> <?php echo e($concern->company_name); ?> <?php else: ?> <?php echo e($concern->company_name_bn); ?> <?php endif; ?></p></a>
                           
                                
                            </div>
                            
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- sponsor section ending here -->



<!-- product section start here -->
<!--<section class="product-section padding-tb">-->
<!--    <div class="container">-->
<!--        <div class="section-header wow fadeInUp" data-wow-delay="0.4s">-->
<!--            <h3><?php if(session()->get('lang') == 'en'): ?> Gallery <?php else: ?> ছবি <?php endif; ?></h3>-->
<!--        </div>-->
<!--        <div class="section-wrapper wow fadeInUp" data-wow-delay="0.5s">-->
<!--            <div class="grid">-->
<!--                <?php $__currentLoopData = App\Models\Gallery::limit(9); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
<!--                    <div class="product-item fruits">-->
<!--                        <div class="product-inner">-->
<!--                            <div class="product-thumb">-->
<!--                                <img src="<?php echo e(asset('public')); ?>/<?php echo e($gallery->image); ?>" alt="product">-->
<!--                            </div>-->
<!--                            <div class="product-content">-->
<!--                                <a href="<?php echo e(asset('public')); ?>/<?php echo e($gallery->image); ?>" data-rel="lightcase" class="product-name"><?php if(session()->get('lang') == 'en'): ?> <?php echo e($gallery->title); ?> <?php else: ?> <?php echo e($gallery->title_bn); ?> <?php endif; ?></a>-->
<!--                            </div>-->
<!--                        </div>-->
<!--                    </div>-->
<!--                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
<!--            </div>-->
<!--        </div>-->
<!--    </div>-->
<!--</section>-->
<!-- product section ending here -->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\ewclold\resources\views/frontend/pages/home/index.blade.php ENDPATH**/ ?>