<?php
    $company = App\Models\Company::first();
?>
<header class="header-section <?php echo $__env->yieldContent('header-class'); ?> ">
    <div class="header-area">
        <div class="container">
            <nav class="navbar navbar-expand-lg">
                <div class="primary-menu">
                    <div class="logo">
                        <a href="/"><img src="<?php echo e(asset('public')); ?>/<?php echo e($company->logo); ?>" alt="logo"></a>
                    </div>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                        <i class="icofont-navigation-menu"></i>
                    </button>
                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <div class="main-area">
                            <div class="main-menu">
                                <ul class="agri-ul">
                                    <li class="<?php echo e('/' == request()->path() ? 'active' : ''); ?>"><a href="/"><?php if(session()->get('lang') == 'en'): ?> Home <?php else: ?> হোম <?php endif; ?></a></li>
                                    <li class="<?php echo e(('about-us' == request()->path() || 'founder-speech' == request()->path() || 'mission-visions' == request()->path() || 'team' == request()->path() ) ? 'active' : ''); ?>">
                                        <a href="#"><?php if(session()->get('lang') == 'en'): ?> About <?php else: ?> আমাদের সম্পর্কে <?php endif; ?></a>
                                        <ul class="agri-ul">
                                            <li><a href="/about-us"><?php if(session()->get('lang') == 'en'): ?> About Us <?php else: ?> আমাদের সম্পর্কে <?php endif; ?></a></li>
                                            <!--<li><a href="/founder-speech"><?php if(session()->get('lang') == 'en'): ?> Founder Speech <?php else: ?> প্রতিষ্ঠাতা বক্তব্য <?php endif; ?></a></li>-->
                                            <li><a href="/mission-visions"><?php if(session()->get('lang') == 'en'): ?> Mission & Visions <?php else: ?> মিশন ও ভিশন <?php endif; ?></a></li>
                                            <li><a href="/team"><?php if(session()->get('lang') == 'en'): ?> Our Team <?php else: ?> আমাদের টীম <?php endif; ?></a></li>
                                            <li><a href="/sister-concern"><?php if(session()->get('lang') == 'en'): ?> Our Sister Concern <?php else: ?> আমাদের সহপ্রতিষ্ঠান <?php endif; ?></a></li>
                                        </ul>
                                    </li>
                                    <li class="<?php echo e('/category/*' == request()->path() ? 'active' : ''); ?>">
                                        <a href="#"><?php if(session()->get('lang') == 'en'): ?> Products <?php else: ?> পণ্য <?php endif; ?></a>
                                        <ul>
                                            <?php $__currentLoopData = App\Models\Category::data(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><a href="/category/<?php echo e($category->slug); ?>"> <?php if(session()->get('lang') == 'en'): ?> <?php echo e($category->name); ?> <?php else: ?> <?php echo e($category->name_bn); ?> <?php endif; ?></a></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </li>
                                    <li class="<?php echo e('depot' == request()->path() ? 'active' : ''); ?>"><a href="/depot"><?php if(session()->get('lang') == 'en'): ?> Depot <?php else: ?> ডিপো <?php endif; ?></a></li>
                                    <li class="<?php echo e('gallery' == request()->path() ? 'active' : ''); ?>"><a href="/gallery"><?php if(session()->get('lang') == 'en'): ?> Gallery <?php else: ?> ছবি <?php endif; ?></a></li>
                                    <!--<li class="<?php echo e('blogs' == request()->path() ? 'active' : ''); ?>"><a href="/blogs"><?php if(session()->get('lang') == 'en'): ?> Blog <?php else: ?> ব্লগ <?php endif; ?></a></li>-->
                                    <li class="<?php echo e('contact-us' == request()->path() ? 'active' : ''); ?>"><a href="/contact-us"><?php if(session()->get('lang') == 'en'): ?> Contact <?php else: ?> যোগাযোগ <?php endif; ?></a></li>
                                    <!--<li>-->
                                    <!--    <a href="#">-->
                                    <!--        <i class="icofont-globe"></i>-->
                                    <!--        <?php if(session()->get('lang') == 'en'): ?> English <?php else: ?> বাংলা <?php endif; ?></a>-->
                                    <!--    <ul class="agri-ul">-->
                                    <!--        <li><a href="/lang/bn">বাংলা</a></li>-->
                                    <!--        <li><a href="/lang/english">English</a></li>-->
                                    <!--    </ul>-->
                                    <!--</li>-->
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </nav>
        </div>
    </div>
</header><?php /**PATH /home/axesba/public_html/daral/resources/views/frontend/includes/header.blade.php ENDPATH**/ ?>