<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <title>EWCL | Admin Dashboard</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta content="A fully featured admin theme which can be used to build CRM, CMS, etc." name="description" />
        <meta content="Coderthemes" name="author" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <!-- App favicon -->
        <link rel="shortcut icon" href="<?php echo e(asset('images')); ?>/icons/icon.png">

		<!-- App css -->

		<link href="<?php echo e(asset('public/backend/assets')); ?>/css/app.min.css" rel="stylesheet" type="text/css" id="app-style" />

		<!-- icons -->
		<link href="<?php echo e(asset('public/backend/assets')); ?>/css/icons.min.css" rel="stylesheet" type="text/css" />

        <!-- Notification css (Toastr) -->
        <link href="<?php echo e(asset('public/backend/assets')); ?>/libs/toastr/build/toastr.min.css" rel="stylesheet" type="text/css" />

        <style>
            .mce-panel{
                border-radius: 0.2rem;
                border: 0 solid #e2e4e7 !important;
            }
        </style>

        <?php echo $__env->yieldContent('head'); ?>

    </head>

    <!-- body start -->
    <body class="loading" data-layout-color="light"  data-layout-mode="default" data-layout-size="fluid" data-topbar-color="light" data-leftbar-position="fixed" data-leftbar-color="light" data-leftbar-size='default' data-sidebar-user='true'>

        <!-- Begin page -->
        <div id="wrapper">
            <?php echo $__env->make('backend.includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo $__env->make('backend.includes.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="content-page">
                <div class="content">
                    <?php echo $__env->yieldContent('content'); ?>
                </div> 

               <?php echo $__env->make('backend.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

        </div>
        <!-- END wrapper -->

        <!-- Vendor -->
        <script src="<?php echo e(asset('public/backend/assets')); ?>/libs/jquery/jquery.min.js"></script>
        <script src="<?php echo e(asset('public/backend/assets')); ?>/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
        <script src="<?php echo e(asset('public/backend/assets')); ?>/libs/simplebar/simplebar.min.js"></script>
        <script src="<?php echo e(asset('public/backend/assets')); ?>/libs/node-waves/waves.min.js"></script>
        <script src="<?php echo e(asset('public/backend/assets')); ?>/libs/waypoints/lib/jquery.waypoints.min.js"></script>
        <script src="<?php echo e(asset('public/backend/assets')); ?>/libs/jquery.counterup/jquery.counterup.min.js"></script>
        <script src="<?php echo e(asset('public/backend/assets')); ?>/libs/feather-icons/feather.min.js"></script>

        <!--tinymce textEditor-->
        <script src="<?php echo e(asset('public/backend/assets')); ?>/tinymce/tinymce.min.js"></script>
        <script type="text/javascript" src="<?php echo e(asset('public/backend/assets')); ?>/tinymce/init-tinymce.js"></script>


        <!-- App js -->
        <script src="<?php echo e(asset('public/backend/assets')); ?>/js/app.min.js"></script>

         <!-- Toastr js -->
         <script src="<?php echo e(asset('public/backend/assets')); ?>/libs/toastr/build/toastr.min.js"></script>
         <?php if(session()->has('message')): ?>
         <?php echo $__env->make('backend.includes.success', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
         <?php endif; ?>
         <?php if(session()->has('error')): ?>
         <?php echo $__env->make('backend.includes.error', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
         <?php endif; ?>


        <?php echo $__env->yieldContent('script'); ?>

        <script>
            $( document ).ready(function() {
                document.getElementById('responsive-datatable').style.width = null;
            });
        </script>
        
    </body>
</html><?php /**PATH /home/axesba/public_html/daral/resources/views/backend/master.blade.php ENDPATH**/ ?>