<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;

Auth::routes();

Route::post('/test', function (Request $request) {
    return 'Hello World';
});

Route::group(['middleware' => 'auth','prefix'=> 'admin'], function () {
    Route::get('/', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

    Route::resource('/slider', App\Http\Controllers\SliderController::class)->name('*','slider');
    Route::resource('/about', App\Http\Controllers\AboutUsController::class)->name('*','about');
    Route::resource('/founder-speech', App\Http\Controllers\FounderSpeechController::class)->name('*','founder-speech');
    Route::resource('/mission-visions', App\Http\Controllers\MissionVisionsController::class)->name('*','mission-visions');
    Route::resource('/team', App\Http\Controllers\TeamController::class)->name('*','team');
    Route::resource('/social-media', App\Http\Controllers\SocialMediaController::class)->name('*','social-media');

    
    Route::resource('/category', App\Http\Controllers\CategoryController::class)->name('*','category');
    Route::resource('/product', App\Http\Controllers\ProductController::class)->name('*','product');

    Route::resource('/company', App\Http\Controllers\CompanyController::class)->name('*','company');

    Route::view('/branch-info',"backend.pages.setting.branch.info");
    Route::post('/branch-info', [App\Http\Controllers\BranchController::class, 'info'])->name('branch-info');
    Route::resource('/branch', App\Http\Controllers\BranchController::class)->name('*','branch');
    Route::resource('/sister-concern', App\Http\Controllers\SisterConcernController::class)->name('*','sister-concern');
    
    Route::resource('/gallery', App\Http\Controllers\GalleryController::class)->name('*','gallery');
    Route::resource('/blog', App\Http\Controllers\BlogController::class)->name('*','blog');
    Route::resource('/message', App\Http\Controllers\MessageController::class)->name('*','message');
});


// Website 

Route::get('/lang/{lang}', [App\Http\Controllers\ViewController::class, 'changeLang'])->name('changeLang');
Route::post('/message-send', [App\Http\Controllers\ViewController::class, 'messageSend'])->name('messageSend');
Route::post('/user-register', [App\Http\Controllers\ViewController::class, 'registerUser'])->name('user-register');
Route::view('/','frontend.pages.home.index'); 
Route::view('/about-us','frontend.pages.about.index'); 
Route::view('/founder-speech','frontend.pages.founder_speech.index'); 
Route::view('/mission-visions','frontend.pages.mission_visions.index'); 
Route::view('/team','frontend.pages.team.index'); 
Route::view('/sister-concern','frontend.pages.sister_concern.index'); 
Route::view('/sister-concern/{slug}','frontend.pages.sister_concern.view'); 
Route::view('/category/{slug}','frontend.pages.product.index'); 
Route::view('/product/{slug}','frontend.pages.product.view');
Route::view('/depot','frontend.pages.depot.index'); 
Route::view('/gallery','frontend.pages.gallery.index'); 
Route::view('/blogs','frontend.pages.blog.index'); 
Route::view('/blogs/{slug}','frontend.pages.blog.view'); 
Route::view('/contact-us','frontend.pages.contact.index'); 

