@extends('frontend.master')
@section('title')
Sister Concern
@endsection
@php
    $concerns = App\Models\SisterConcern::all();
    $branchInfo = App\Models\BranchIntro::first();
@endphp
@section('meta')
    <meta name="title" content="{{$branchInfo->meta_title}}">
    <meta name="description" content="{{$branchInfo->meta_des}}">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{url()->current()}}">
    <meta property="og:title" content="{{$branchInfo->meta_title}}">
    <meta property="og:description" content="{{$branchInfo->meta_des}}">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="{{url()->current()}}">
    <meta property="twitter:title" content="{{$branchInfo->meta_title}}">
    <meta property="twitter:description" content="{{$branchInfo->meta_des}}">

@endsection
@section('content')

 <!-- Page Header Section Start Here -->
 <section class="page-header bg_img padding-tb">
    <div class="overlay"></div>
    <div class="container">
        <div class="page-header-content-area">
            <h4 class="ph-title">@if(session()->get('lang') == 'en') Our Sister Concern @else আমাদের সহপ্রতিষ্ঠান @endif</h4>
            <ul class="agri-ul">
                <li><a href="/">@if(session()->get('lang') == 'en') Home @else হোম @endif</a></li>
                <li><a class="active">@if(session()->get('lang') == 'en') Our Sister Concern @else আমাদের সহপ্রতিষ্ঠান @endif</a></li>
            </ul>
        </div>
    </div>
</section>
<!-- Page Header Section Ending Here -->

<!-- Service Section Start Here -->
<section class="service-section padding-tb">
    <div class="container">
        <div class="section-wrapper">
            <div class="row justify-content-center">
                @foreach ($concerns as $concern)
                <div class="col-xl-4 col-md-6 col-12">
                    <div class="lab-item">
                        <div class="lab-inner">
                            <div class="lab-content">
                                <a href="{{$concern->link}}" target="_blank"><img src="{{asset('public')}}/{{$concern->logo}}" alt="sister-concern"></a>
                                <h5 class="mt-2"><a href="sister-concern/{{$concern->slug}}">@if(session()->get('lang') == 'en') {{$concern->company_name}} @else {{$concern->company_name_bn}}  @endif</a></h5>
                                <p><strong>Call:</strong> @if(session()->get('lang') == 'en') {{$concern->phone}} @else {{$concern->phone_bn}}  @endif</p>
                                <p><strong>E-Mail:</strong> {{$concern->email}} </p>
                                <p><strong>Address:</strong> @if(session()->get('lang') == 'en') {{$concern->address}} @else {{$concern->address_bn}}  @endif </p>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</section>
@endsection