@extends('frontend.master')
@section('title')
Product Details
@endsection
@php
    $product = App\Models\Product::where('slug',explode('product/',request()->path())[1])->first();
@endphp
@section('meta')
    <meta name="title" content="{{$product->meta_title}}">
    <meta name="description" content="{{$product->meta_des}}">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{url()->current()}}">
    <meta property="og:title" content="{{$product->meta_title}}">
    <meta property="og:description" content="{{$product->meta_des}}">
    <meta property="og:image" content="{{asset('public')}}/{{$product->image}}">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="{{url()->current()}}">
    <meta property="twitter:title" content="{{$product->meta_title}}">
    <meta property="twitter:description" content="{{$product->meta_des}}">
    <meta property="twitter:image" content="{{asset('public')}}/{{$product->image}}">
    <style>
        .border {
            border: 1px solid #f7faff;
        }
        img {
            width: 100%;
        }
    </style>
@endsection


@section('content')

 <!-- Page Header Section Start Here -->
 <section class="page-header bg_img padding-tb">
    <div class="overlay"></div>
    <div class="container">
        <div class="page-header-content-area">
            <h4 class="ph-title">@if(session()->get('lang') == 'en') {{$product->name}} @else {{$product->name_bn}} @endif</h4>
            <ul class="agri-ul">
                <li><a href="/">@if(session()->get('lang') == 'en') Home @else হোম @endif</a></li>
                <li><a href="/category/{{$product->category->slug}}">@if(session()->get('lang') == 'en') {{$product->category->name}} @else {{$product->category->name_bn}} @endif</a></li>
                <li><a class="active">@if(session()->get('lang') == 'en') Product @else পণ্য @endif</a></li>
            </ul>
        </div>
    </div>
</section>
<!-- Page Header Section Ending Here -->

<div class="blog-section blog-single padding-tb">
    <div class="container">
        <div class="section-wrapper">
            <div class="row justify-content-center">
                <div class="col-lg-4 col-md-4 col-12">
                    <article>
                        <div class="post-item-2">
                            <div class="post-inner">
                                <div class="post-thumb">
                                    <img src="{{asset('public')}}/{{$product->image}}" alt="product" class="br-5">
                                </div>
                            </div>
                        </div>
                    </article>
                </div>
                <div class="col-lg-8 col-md-8 col-12">
                    <article>
                        <div class="post-item-2">
                            <div class="post-inner">
                                <div class="post-content">
                                    <h4>@if(session()->get('lang') == 'en') {{$product->name}} @else {{$product->name_bn}} @endif</h4>
                                    @if(session()->get('lang') == 'en') {!! $product->description !!} @else {!! $product->description_bn !!} @endif
                                </div>
                            </div>
                        </div>
                    </article>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
    <script>
        var tables = document.getElementsByTagName('table');
        console.log(tables);
        for (let index = 0; index < tables.length; index++) {
            tables[index].className = "table table-bordered";
        }
        
    </script>
@endsection