@extends('frontend.master')
@section('title')
Product Category
@endsection

@php
    $category = App\Models\Category::where('slug',explode('category/',request()->path())[1])->first();
@endphp
@section('meta')
    <meta name="title" content="{{$category->name}}">
    <meta name="description" content="{{$category->description}}">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{url()->current()}}">
    <meta property="og:title" content="{{$category->name}}">
    <meta property="og:description" content="{{$category->description}}">
    <meta property="og:image" content="{{asset('public')}}/{{$category->image}}">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="{{url()->current()}}">
    <meta property="twitter:title" content="{{$category->name}}">
    <meta property="twitter:description" content="{{$category->description}}">
    <meta property="twitter:image" content="{{asset('public')}}/{{$category->image}}">

@endsection
@section('content')

 <!-- Page Header Section Start Here -->
 <section class="page-header bg_img padding-tb">
    <div class="overlay"></div>
    <div class="container">
        <div class="page-header-content-area">
            <h4 class="ph-title">@if(session()->get('lang') == 'en') {{$category->name}} @else {{$category->name_bn}} @endif</h4>
            <ul class="agri-ul">
                <li><a href="/">@if(session()->get('lang') == 'en') Home @else হোম @endif</a></li>
                <li><a class="active">@if(session()->get('lang') == 'en') Product @else পণ্য @endif</a></li>
            </ul>
        </div>
    </div>
</section>
<!-- Page Header Section Ending Here -->

<!-- shop page Section Start Here -->
<div class="shop-page padding-tb">
    <div class="container">
        <div class="section-wrapper">
            <div class="row justify-content-center">
                <div class="col-lg-12 col-12">
                    <article>
                        <div class="shop-product-wrap grids row justify-content-center">
                            @foreach ($category->product as $product)
                                <div class="col-lg-4 col-md-6 col-12">
                                    <div class="product-item">
                                        <div class="product-thumb">
                                            <img src="{{asset('public')}}/{{$product->image}}" alt="shope">
                                            <div class="product-action-link">
                                                <a href="/product/{{$product->slug}}"><i class="icofont-eye"></i></a>
                                            </div>
                                        </div>
                                        <div class="product-content">
                                            <h6><a href="/product/{{$product->slug}}">@if(session()->get('lang') == 'en') {{$product->name}} @else {{$product->name_bn}}  @endif</a></h6>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </article>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- shop page Section ENding Here -->
@endsection