@extends('frontend.master')
@section('title')
Gallery
@endsection
@php
    $company = App\Models\Company::first();
@endphp
@section('meta')
    <meta name="title" content="{{$company->meta_title}}">
    <meta name="description" content="{{$company->meta_des}}">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{url()->current()}}">
    <meta property="og:title" content="{{$company->meta_title}}">
    <meta property="og:description" content="{{$company->meta_des}}">
    <meta property="og:image" content="{{asset('public')}}/{{$company->logo}}">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="{{url()->current()}}">
    <meta property="twitter:title" content="{{$company->meta_title}}">
    <meta property="twitter:description" content="{{$company->meta_des}}">
    <meta property="twitter:image" content="{{asset('public')}}/{{$company->logo}}">

@endsection
@section('content')
@php
    $galleries = App\Models\Gallery::get();
@endphp
 <!-- Page Header Section Start Here -->
 <section class="page-header bg_img padding-tb">
    <div class="overlay"></div>
    <div class="container">
        <div class="page-header-content-area">
            <h4 class="ph-title">@if(session()->get('lang') == 'en') Gallery @else ছবি @endif</h4>
            <ul class="agri-ul">
                <li><a href="/">@if(session()->get('lang') == 'en') Home @else হোম @endif</a></li>
                <li><a class="active">@if(session()->get('lang') == 'en') Gallery @else ছবি @endif</a></li>
            </ul>
        </div>
    </div>
</section>
<!-- Page Header Section Ending Here -->

<!-- product section start here -->
<div class="product-section grid-2 padding-tb">
    <div class="container">
        <div class="section-wrapper">
            <div class="row justify-content-center">
                @foreach ($galleries as $gallery)
                <div class="col-md-6 col-12">
                    <div class="product-item">
                        <div class="product-inner">
                            <div class="product-thumb">
                                <img src="{{asset('public')}}/{{$gallery->image}}" alt="product">
                            </div>
                            <div class="product-content">
                                <a href="{{asset('public')}}/{{$gallery->image}}" data-rel="lightcase" class="product-name">@if(session()->get('lang') == 'en') {{$gallery->title}} @else {{$gallery->title_bn}} @endif</a>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
<!-- product section ending here -->
@endsection