@extends('frontend.master')
@section('title')
Founder Speech
@endsection
@php
    $data = App\Models\FounderSpeech::first();
@endphp
@section('meta')
    <meta name="title" content="{{$data->meta_title}}">
    <meta name="description" content="{{$data->meta_des}}">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{url()->current()}}">
    <meta property="og:title" content="{{$data->meta_title}}">
    <meta property="og:description" content="{{$data->meta_des}}">
    <meta property="og:image" content="{{asset('public')}}/{{$data->image}}">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="{{url()->current()}}">
    <meta property="twitter:title" content="{{$data->meta_title}}">
    <meta property="twitter:description" content="{{$data->meta_des}}">
    <meta property="twitter:image" content="{{asset('public')}}/{{$data->image}}">

@endsection

@section('content')

 <!-- Page Header Section Start Here -->
 <section class="page-header bg_img padding-tb">
    <div class="overlay"></div>
    <div class="container">
        <div class="page-header-content-area">
            <h4 class="ph-title">@if(session()->get('lang') == 'en') Founder Speech @else প্রতিষ্ঠাতা বক্তব্য @endif</h4>
            <ul class="agri-ul">
                <li><a href="/">@if(session()->get('lang') == 'en') Home @else হোম @endif</a></li>
                <li><a class="active">@if(session()->get('lang') == 'en') Founder Speech @else প্রতিষ্ঠাতা বক্তব্য @endif</a></li>
            </ul>
        </div>
    </div>
</section>
<!-- Page Header Section Ending Here -->

<div class="blog-section blog-single padding-tb">
    <div class="container">
        <div class="section-wrapper">
            <div class="row justify-content-center">
                <div class="col-lg-6 col-md-8 col-12">
                    <article>
                        <div class="post-item-2">
                            <div class="post-inner">
                                <div class="post-thumb">
                                    <div class="row justify-content-center">
                                        <div class="col-xl-4 col-lg-6 col-sm-6 col-12">
                                            <div class="team-item-2">
                                                <div class="team-inner">
                                                    <div class="team-thumb">
                                                        <img src="{{asset('public')}}/{{$data->image}}" alt="team-image" class="br-5">
                                                    </div>
                                                    <div class="team-content">
                                                        <a href="#"><h5>@if(session()->get('lang') == 'en') {{$data->name}} @else {{$data->name_bn}} @endif</h5></a>
                                                        <p>@if(session()->get('lang') == 'en') {{$data->designation}} @else {{$data->designation_bn}} @endif</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </article>
                </div>
                <div class="col-lg-6 col-md-8 col-12">
                    <article>
                        <div class="post-item-2">
                            <div class="post-inner">
                                <div class="post-content">
                                    <h4>@if(session()->get('lang') == 'en') {{$data->title}} @else {{$data->title_bn}} @endif</h4>
                                    @if(session()->get('lang') == 'en') {!! $data->speech !!} @else {!! $data->speech_bn !!} @endif
                                </div>
                            </div>
                        </div>
                    </article>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection