@extends('frontend.master')
@section('title')
Contact Us
@endsection
@php
    $company = App\Models\Company::first();
@endphp
@section('meta')
    <meta name="title" content="{{$company->meta_title}}">
    <meta name="description" content="{{$company->meta_des}}">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{url()->current()}}">
    <meta property="og:title" content="{{$company->meta_title}}">
    <meta property="og:description" content="{{$company->meta_des}}">
    <meta property="og:image" content="{{asset('public')}}/{{$company->logo}}">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="{{url()->current()}}">
    <meta property="twitter:title" content="{{$company->meta_title}}">
    <meta property="twitter:description" content="{{$company->meta_des}}">
    <meta property="twitter:image" content="{{asset('public')}}/{{$company->logo}}">

@endsection

@section('content')

 <!-- Page Header Section Start Here -->
 <section class="page-header bg_img padding-tb">
    <div class="overlay"></div>
    <div class="container">
        <div class="page-header-content-area">
            <h4 class="ph-title">@if(session()->get('lang') == 'en') Contact @else যোগাযোগ @endif</h4>
            <ul class="agri-ul">
                <li><a href="/">@if(session()->get('lang') == 'en') Home @else হোম @endif</a></li>
                <li><a class="active">@if(session()->get('lang') == 'en') Contact @else যোগাযোগ @endif</a></li>
            </ul>
        </div>
    </div>
</section>
<!-- Page Header Section Ending Here -->

<div class="contact-section padding-tb">
    <div class="container">
        <div class="contac-top">
            <div class="row justify-content-center">
                <div class="col-xl-4 col-lg-6 col-12">
                    <div class="contact-item">
                        <div class="contact-icon">
                            <i class="icofont-google-map"></i>
                        </div>
                        <div class="contact-details">
                            <p>@if(session()->get('lang') == 'en') {{$company->address}} @else {{$company->address_bn}} @endif</p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-6 col-12">
                    <div class="contact-item">
                        <div class="contact-icon">
                            <i class="icofont-phone"></i>
                        </div>
                        <div class="contact-details">
                            <p>@if(session()->get('lang') == 'en') {{$company->phone}} @else {{$company->phone_bn}} @endif</p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-6 col-12">
                    <div class="contact-item">
                        <div class="contact-icon">
                            <i class="icofont-envelope"></i>
                        </div>
                        <div class="contact-details">
                            <p>{{$company->email}}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="contac-bottom">
            
            @if(session()->has('message'))
                <div class="alert alert-success" role="alert">
                    {{session()->get('message')}}
                </div>
            @endif
            <div class="row justify-content-center">
                <div class="col-lg-6 col-12">
                    <div class="location-map">
                        <div id="map">
                            <iframe src="{{$company->google_maps}}" allowfullscreen=""></iframe>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-12">
                    <div class="contact-form">
                        <form action="/message-send" method="POST" id="commentform" class="comment-form">
                            @csrf
                            <input type="text" name="name" class="" placeholder="Name*" required>
                            <input type="text" name="number" class="" placeholder="Number*" required>
                            <input type="email" name="email" class="" placeholder="Email*" required>
                            <input type="text" name="subject" class="" placeholder="Subject*" required>
                            <textarea id="role" name="message" cols="30" rows="10" placeholder="Message*" required></textarea>
                            <button type="submit" class="lab-btn">
                                <span>Submit Now</span>
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection