@extends('frontend.master')
@section('title')
About Us
@endsection
@php
    $about = App\Models\AboutUs::first();
@endphp
@section('meta')
    <meta name="title" content="{{$about->meta_title}}">
    <meta name="description" content="{{$about->meta_des}}">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{url()->current()}}">
    <meta property="og:title" content="{{$about->meta_title}}">
    <meta property="og:description" content="{{$about->meta_des}}">
    <meta property="og:image" content="{{asset('public')}}/{{$about->image}}">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="{{url()->current()}}">
    <meta property="twitter:title" content="{{$about->meta_title}}">
    <meta property="twitter:description" content="{{$about->meta_des}}">
    <meta property="twitter:image" content="{{asset('public')}}/{{$about->image}}">

@endsection
@section('head')

@endsection

@section('content')

 <!-- Page Header Section Start Here -->
 <section class="page-header bg_img padding-tb">
    <div class="overlay"></div>
    <div class="container">
        <div class="page-header-content-area">
            <h4 class="ph-title">@if(session()->get('lang') == 'en') About @else আমাদের সম্পর্কে @endif</h4>
            <ul class="agri-ul">
                <li><a href="/">@if(session()->get('lang') == 'en') Home @else হোম @endif</a></li>
                <li><a class="active">@if(session()->get('lang') == 'en') About @else আমাদের সম্পর্কে @endif</a></li>
            </ul>
        </div>
    </div>
</section>
<!-- Page Header Section Ending Here -->

<div class="blog-section blog-single padding-tb">
    <div class="container">
        <div class="section-wrapper">
            <div class="row justify-content-center">
                <div class="col-lg-6 col-md-8 col-12">
                    <article>
                        <div class="post-item-2">
                            <div class="post-inner">
                                <div class="post-thumb">
                                    <img src="{{asset('public')}}/{{$about->image}}" alt="blog" class="br-5">
                                </div>
                            </div>
                        </div>
                    </article>
                </div>
                <div class="col-lg-6 col-md-8 col-12">
                    <article>
                        <div class="post-item-2">
                            <div class="post-inner">
                                <div class="post-content">
                                    <h4>@if(session()->get('lang') == 'en') {{$about->title}} @else {{$about->title_bn}} @endif</h4>
                                    @if(session()->get('lang') == 'en') {!! $about->description !!} @else {!! $about->description_bn !!} @endif
                                </div>
                            </div>
                        </div>
                    </article>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection