@extends('admin.master')
@section('title')
Sub Category
@endsection

@section('head')
<link href="{{asset('backend/assets')}}/libs/mohithg-switchery/switchery.min.css" rel="stylesheet" type="text/css" />
<link href="{{asset('backend/assets')}}/libs/multiselect/css/multi-select.css" rel="stylesheet" type="text/css" />
<link href="{{asset('backend/assets')}}/libs/select2/css/select2.min.css" rel="stylesheet" type="text/css" />
<link href="{{asset('backend/assets')}}/libs/selectize/css/selectize.bootstrap3.css" rel="stylesheet" type="text/css" />
<link href="{{asset('backend/assets')}}/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" type="text/css" />
@endsection
@section('content')
    <!-- Start Content-->
    <div class="container-fluid">

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">

                        <h4 class="mb-3 header-title">Update Sub Category</h4>

                        <form action="{{route('sub-category.update',$category->id)}}" method="POST" enctype="multipart/form-data">
                            @csrf @method('PUT')
                            <div class="mb-3">
                                <label for="name" class="form-label">Name</label>
                                <input type="text" class="form-control" name="name" id="name" value="{{$category->name}}" placeholder="Enter category name" required>
                                @error('title')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <label for="select-category" class="form-label">Category</label>
                                    <select id="select-category" class="selectize-drop-header" name="category" placeholder="Select a Category..." required>
                                        <option value="">Select Category</option>
                                        @foreach ($categories as $data)
                                        <optgroup label="{{$data->name}}">
                                            <option value="{{$data->id}}" @if($category->category_id == $data->id) @selected(true) @endif>{{$data->name}}</option>
                                        </optgroup>
                                        @endforeach
                                    </select>
                                    @error('category')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>
                            </div>
                            <div class="mb-3">
                                <label for="image" class="form-label">Image</label>
                                <input type="file" class="d-none" name="image" id="input_file1"
                                            onchange="showImage.call(this)">
                                    <br>
                                    @error('image') <code>{{ $message }}</code> @enderror
                                    <label for="input_file1"><i class="ion-upload"></i> <img class="img-fluid img-round img-profile" width="100" id="image"
                                            src="@if(empty($category->image)) {{ asset('backend/img') }}/upload_img.png @else {{$category->image}} @endif"
                                            alt="Category Picture"></label>
                                    @error('image')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                
                            </div>
                            <div class="row">
                                <div class="col-md-12  mb-3">
                                    <label for="status" class="form-label">Published Status</label>
                                    <select class="form-control" name="status" placeholder="Select a Published Status..." required>
                                        <option value="1" @if($category->status == 1) @selected(true) @endif>YES</option>
                                        <option value="0"  @if($category->status == 0) @selected(true) @endif>NO</option>
                                    </select>
                                    @error('status')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>
                            </div>
                            <button type="submit" class="btn btn-info waves-effect waves-light">Update</button>
                        </form>

                    </div>  <!-- end card-body -->
                </div>  <!-- end card -->
            </div>
        </div>
    
    </div>
@endsection
@section('script')
<script>
    function showImage() {
        if (this.files && this.files[0]) {
            var obj = new FileReader();
            obj.onload = function (data) {
                var image = document.getElementById("image");
                image.src = data.target.result;
                // image.classList.add("img-fluid img-round");
                image.width = 1000;
                // image.style.height = 'auto'
            }
            console.log(image);
            obj.readAsDataURL(this.files[0]);
        }
    }

</script>
 
<script src="{{asset('backend/assets')}}/libs/selectize/js/standalone/selectize.min.js"></script>
<script src="{{asset('backend/assets')}}/libs/mohithg-switchery/switchery.min.js"></script>
<script src="{{asset('backend/assets')}}/libs/multiselect/js/jquery.multi-select.js"></script>
<script src="{{asset('backend/assets')}}/libs/select2/js/select2.min.js"></script>
<script src="{{asset('backend/assets')}}/libs/jquery-mockjax/jquery.mockjax.min.js"></script>
<script src="{{asset('backend/assets')}}/libs/devbridge-autocomplete/jquery.autocomplete.min.js"></script>
<script src="{{asset('backend/assets')}}/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
<script src="{{asset('backend/assets')}}/libs/bootstrap-maxlength/bootstrap-maxlength.min.js"></script> 
<!-- Init js-->
<script src="{{asset('backend/assets')}}/js/pages/form-advanced.init.js"></script>
@endsection
