@extends('admin.master')
@section('title') Specifications @endsection
@section('content')
@php
    $index = 1;
@endphp
    <!-- Start Content-->
    <div class="container-fluid">

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <div class="float-end">
                            <a href="#" data-bs-toggle="modal" data-bs-target="#create-specification-modal" class="btn btn-purple rounded-pill w-md waves-effect waves-light mb-3"><i class="mdi mdi-plus"></i> Create Specification</a>
                        </div>
                        <h4 class="mt-0 header-title">Specification List</h4>
                        <p class="text-muted font-14 mb-3">
                            Used <code>specification</code> to add all type f post
                        </p>

                        <div class="table-responsive">
                            <table class="table table-striped mb-0">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Title</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($specifications as $specification)
                                    <tr>
                                        <th scope="row">{{$index++}}</th>
                                        <td>{{$specification->title}}</td>
                                        <td class="text-center">
                                            <button type="button" class="btn btn-purple btn-sm waves-effect waves-light" data-bs-toggle="modal" data-bs-target="#edit-specification-modal-{{$specification->id}}"><i class="mdi mdi-pencil"></i></button>
                                            <button type="button" class="btn btn-danger btn-sm waves-effect waves-light" data-bs-toggle="modal" data-bs-target="#danger-alert-modal-{{$specification->id}}"><i class="mdi mdi-delete-outline"></i></button>
                                            
                                        </td>
                                    </tr>

                                    {{-- delete alert --}}
                                    <div id="danger-alert-modal-{{$specification->id}}" class="modal fade" tabindex="-1" style="display: none;" aria-hidden="true">
                                        <div class="modal-dialog modal-sm">
                                            <div class="modal-content modal-filled bg-default">
                                                <div class="modal-body">
                                                    <div class="text-center">
                                                        <i class="dripicons-wrong h1 text-danger"></i>
                                                        <h3 class="mt-1">Are you sure?</h3>
                                                        <p class="mt-1">You won't be able to revert this!</p>
                                                        <form action="{{route('specification.destroy', $specification->id)}}" method="post" class="d-inline-block">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-purple waves-effect waves-light" data-bs-toggle="modal" data-bs-target="#danger-alert-modal-{{$specification->id}}">Yes, delete it!</button>
                                                        </form>
                                                        <button type="button" class="btn btn-danger waves-effect waves-light my-2" data-bs-dismiss="modal">Cancel</button>
                                                    </div>
                                                </div>
                                            </div><!-- /.modal-content -->
                                        </div><!-- /.modal-dialog -->
                                    </div>
                                    {{-- edit specification model --}}
                                    <div id="edit-specification-modal-{{$specification->id}}" class="modal fade" tabindex="-1" style="display: none;" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-body">
                                                    <div class="text-center mt-2 mb-4">
                                                        <h2>Update Specification</h2>
                                                    </div>

                                                    <form action="{{route('specification.update',$specification->id)}}" method="POST" class="px-3">
                                                        @csrf @method('PUT')
                                                        <div class="mb-3">
                                                            <label for="title" class="form-label">Title</label>
                                                            <input class="form-control" type="text" id="title" name="title" value="{{$specification->name}}" required="" placeholder="Enter specification Name">
                                                        </div>

                                                        <div class="mb-3 text-center">
                                                            <button class="btn rounded-pill btn-purple" type="submit"><i class="mdi mdi-pencil"></i> Update</button>
                                                        </div>

                                                    </form>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    
    </div>

    {{-- create specification model --}}
    <div id="create-specification-modal" class="modal fade" tabindex="-1" style="display: none;" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="text-center mt-2 mb-4">
                        <h2>Add Specification</h2>
                    </div>

                    <form action="{{route('specification.store')}}" method="POST" class="px-3">
                        @csrf
                        <div class="mb-3">
                            <label for="title" class="form-label">Title</label>
                            <input class="form-control" type="text" id="title" name="title" required="" placeholder="Enter specification name">
                        </div>

                        <div class="mb-3 text-center">
                            <button class="btn rounded-pill btn-purple" type="submit"><i class="mdi mdi-plus"></i> Create</button>
                        </div>

                    </form>

                </div>
            </div>
        </div>
    </div>
@endsection