@extends('backend.master')
@section('title')
Product
@endsection

@section('head')
<link href="{{asset('public/backend/assets')}}/libs/mohithg-switchery/switchery.min.css" rel="stylesheet" type="text/css" />
<link href="{{asset('public/backend/assets')}}/libs/multiselect/css/multi-select.css" rel="stylesheet" type="text/css" />
<link href="{{asset('public/backend/assets')}}/libs/select2/css/select2.min.css" rel="stylesheet" type="text/css" />
<link href="{{asset('public/backend/assets')}}/libs/selectize/css/selectize.bootstrap3.css" rel="stylesheet" type="text/css" />
<link href="{{asset('public/backend/assets')}}/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" type="text/css" />
<style>
    .specification{
        background-color: #ededed;
        border-radius: 10px;
    }
</style>

@endsection
@section('content')
    <div class="container-fluid">

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="mb-3 header-title">Update Product</h4>
                        <form action="{{route('product.update',$product)}}" method="POST" enctype="multipart/form-data">
                            @csrf
                           @method('PUT')
                           <div class="mb-3">
                                <label for="image" class="form-label">Image (Size: 356 × 302 px)</label>
                                <input type="file" class="d-none" name="image" id="input_file1"
                                            onchange="showImage.call(this)">
                                    <br>
                                    @error('image') <code>{{ $message }}</code> @enderror
                                    <label for="input_file1"><i class="ion-upload"></i> 
                                    @if(is_null($product->image))
                                    <img class="img-fluid rounded img-profile" width="100" id="image"
                                            src="{{ asset('backend/img') }}/upload_img.png"
                                            alt="product Picture"> </label>
                                    @else
                                    <img class="img-fluid rounded img-profile" width="400" id="image"
                                            src="{{ asset('public') }}/{{$product->image}}"
                                            alt="product Picture"> </label>
                                    @endif
                                    @error('image')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                
                            </div>
                            <div class="mb-3">
                                <label for="select-category" class="form-label">Category<code>*</code></label>
                                <select id="select-category" class="selectize-drop-header" name="category_id" placeholder="Select a Category..." required>
                                    <option value="">Select Category</option>
                                    @foreach ($categories as $category)
                                    <option value="{{$category->id}}" @if($product->category_id == $category->id) selected @endif>{{$category->name}}</option>
                                    @endforeach
                                </select>
                                @error('category_id')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label for="name_bn" class="form-label">নাম</label>
                                <input type="text" class="form-control" name="name_bn" id="name_bn" value="{{$product->name_bn}}" placeholder="বিভাগের নাম লিখুন" required>
                                @error('name_bn')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label for="name" class="form-label">Name</label>
                                <input type="text" class="form-control" name="name" id="name" value="{{$product->name}}" placeholder="Enter category name" required>
                                @error('name')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label for="rank" class="form-label">Rank</label>
                                <input type="number" class="form-control" name="rank" value="{{$product->rank}}"  id="rank" placeholder="Enter rank">
                                @error('rank')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="description_bn" class="form-label">বর্ণনা</label>
                                <textarea type="text" class="form-control tinymce" name="description_bn" id="description_bn" placeholder="বর্ণনা লিখুন">{{$product->description_bn}}</textarea>
                                @error('description_bn')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="description" class="form-label">Description</label>
                                <textarea type="text" class="form-control tinymce" name="description" id="description" placeholder="Enter description">{{$product->description}}</textarea>
                                @error('description')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <button type="submit" class="btn btn-info waves-effect waves-light">Update Product</button>
                        </form>
                    </div> 
                </div> 
            </div>
        </div>
    
    </div>
@endsection
@section('script')
<script>
    function showImage() {
        if (this.files && this.files[0]) {
            var obj = new FileReader();
            obj.onload = function (data) {
                var image = document.getElementById("image");
                image.src = data.target.result;
                // image.classList.add("img-fluid img-round");
                image.width = 200;
                // image.style.height = 'auto'
            }
            console.log(image);
            obj.readAsDataURL(this.files[0]);
        }
    }

</script>
  

<script src="{{asset('public/backend/assets')}}/libs/selectize/js/standalone/selectize.min.js"></script>
<script src="{{asset('public/backend/assets')}}/libs/mohithg-switchery/switchery.min.js"></script>
<script src="{{asset('public/backend/assets')}}/libs/multiselect/js/jquery.multi-select.js"></script>
<script src="{{asset('public/backend/assets')}}/libs/select2/js/select2.min.js"></script>
<script src="{{asset('public/backend/assets')}}/libs/jquery-mockjax/jquery.mockjax.min.js"></script>
<script src="{{asset('public/backend/assets')}}/libs/devbridge-autocomplete/jquery.autocomplete.min.js"></script>
<script src="{{asset('public/backend/assets')}}/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
<script src="{{asset('public/backend/assets')}}/libs/bootstrap-maxlength/bootstrap-maxlength.min.js"></script>

<!-- Init js-->
<script src="{{asset('public/backend/assets')}}/js/pages/form-advanced.init.js"></script>
@endsection
