@extends('backend.master')
@section('title') Gallery @endsection
@section('content')
@php
    $index = 1;
@endphp
    <!-- Start Content-->
    <div class="container-fluid">
        <div class="row">
            <div>
                <div class="float-end">
                    <a href="{{route('gallery.create')}}" class="btn btn-purple rounded-pill w-md waves-effect waves-light mb-3"><i class="mdi mdi-plus"></i> Add Image</a>
                </div>
            </div>
            @foreach ($galleries as $gallery)
                <div class="col-md-6 col-xl-3">
                    <div class="card">
                        <img class="card-img-top img-fluid" src="{{asset('public')}}/{{$gallery->image}}" alt="Card image cap">
                        <div class="card-body">
                            <h4 class="card-title">{{$gallery->title_bn}}</h4>
                            <a href="{{route('gallery.edit',$gallery->id)}}" class="btn btn-primary"><i class="mdi mdi-pencil"></i></a>
                            <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#danger-alert-modal-{{$gallery->id}}"><i class="mdi mdi-delete-outline"></i></button>
                        </div>
                    </div>
                </div>
                {{-- delete alert --}}
                <div id="danger-alert-modal-{{$gallery->id}}" class="modal fade" tabindex="-1" style="display: none;" aria-hidden="true">
                    <div class="modal-dialog modal-sm">
                        <div class="modal-content modal-filled bg-default">
                            <div class="modal-body">
                                <div class="text-center">
                                    <i class="dripicons-wrong h1 text-danger"></i>
                                    <h3 class="mt-1">Are you sure?</h3>
                                    <p class="mt-1">You won't be able to revert this!</p>
                                    <form action="{{route('gallery.destroy', $gallery->id)}}" method="post" class="d-inline-block">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-purple waves-effect waves-light" data-bs-toggle="modal" data-bs-target="#danger-alert-modal-{{$gallery->id}}">Yes, delete it!</button>
                                    </form>
                                    <button type="button" class="btn btn-danger waves-effect waves-light my-2" data-bs-dismiss="modal">Cancel</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
            
        </div>
    
    </div>

@endsection

    