@extends('backend.master')
@section('title')
Category
@endsection

@section('head')
@endsection
@section('content')

    <div class="container-fluid">

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">

                        <h4 class="mb-3 header-title">Update Category</h4>

                        <form action="{{route('category.update',$category)}}" method="POST" enctype="multipart/form-data">
                            @csrf
                           @method('PUT')
                           <div class="mb-3">
                                <label for="image" class="form-label">Image (size: 177px X 122 px - png formate)</label>
                                <input type="file" class="d-none" name="image" id="input_file1"
                                            onchange="showImage.call(this)">
                                    <br>
                                    @error('image') <code>{{ $message }}</code> @enderror
                                    <label for="input_file1"><i class="ion-upload"></i> 
                                    @if(is_null($category->image))
                                    <img class="img-fluid rounded img-profile" width="100" id="image"
                                            src="{{ asset('public/backend/img') }}/upload_img.png"
                                            alt="category Picture"> </label>
                                    @else
                                    <img class="img-fluid rounded img-profile" width="400" id="image"
                                            src="{{ asset('') }}{{$category->image}}"
                                            alt="category Picture"> </label>
                                    @endif
                                    @error('image')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                
                            </div>
                            
                            <div class="mb-3">
                                <label for="name_bn" class="form-label">নাম</label>
                                <input type="text" class="form-control" name="name_bn" id="name_bn" value="{{$category->name_bn}}" placeholder="বিভাগের নাম লিখুন" required>
                                @error('name_bn')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label for="name" class="form-label">Name</label>
                                <input type="text" class="form-control" name="name" id="name" value="{{$category->name}}" placeholder="Enter category name" required>
                                @error('name')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label for="rank" class="form-label">Rank</label>
                                <input type="number" class="form-control" name="rank" value="{{$category->rank}}"  id="rank" placeholder="Enter rank">
                                @error('rank')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="description_bn" class="form-label">বর্ণনা</label>
                                <textarea type="text" class="form-control" name="description_bn" id="description_bn" placeholder="বর্ণনা লিখুন">{{$category->description_bn}}</textarea>
                                @error('description_bn')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="description" class="form-label">Description</label>
                                <textarea type="text" class="form-control" name="description" id="description" placeholder="Enter description">{{$category->description}}</textarea>
                                @error('description')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <button type="submit" class="btn btn-info waves-effect waves-light">UPDATE</button>
                        </form>

                    </div>  <!-- end card-body -->
                </div>  <!-- end card -->
            </div>
        </div>
    
    </div>
@endsection
@section('script')
<script>
    function showImage() {
        if (this.files && this.files[0]) {
            var obj = new FileReader();
            obj.onload = function (data) {
                var image = document.getElementById("image");
                image.src = data.target.result;
                // image.classList.add("img-fluid img-round");
                image.width = 200;
                // image.style.height = 'auto'
            }
            console.log(image);
            obj.readAsDataURL(this.files[0]);
        }
    }

</script>
  

@endsection
