@extends('backend.master')
@section('title') Blog @endsection
@section('head')
    <!-- third party css -->
    <link href="{{asset('backend/assets')}}/libs/datatables.net-bs5/css/dataTables.bootstrap5.min.css" rel="stylesheet" type="text/css" />
    <link href="{{asset('backend/assets')}}/libs/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css" rel="stylesheet" type="text/css" />
    <link href="{{asset('backend/assets')}}/libs/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css" rel="stylesheet" type="text/css" />
    <link href="{{asset('backend/assets')}}/libs/datatables.net-select-bs5/css//select.bootstrap5.min.css" rel="stylesheet" type="text/css" />
@endsection
@section('content')

    <!-- Start Content-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="float-end">
                            <a href="{{route('blog.create')}}" class="btn btn-purple rounded-pill w-md waves-effect waves-light mb-3"><i class="mdi mdi-plus"></i> Create Blog</a>
                        </div>
                        <h4 class="mt-0 header-title">Blog List</h4>
                        <p class="text-muted font-14 mb-3">
                            EWCL All <code>Blogs</code>
                        </p>

                        <table id="responsive-datatable" class="table table-bordered table-bordered dt-responsive nowrap">
                            <thead>
                                <tr>
                                    <th>#Rank</th>
                                    <th>Image</th>
                                    <th>Title</th>
                                    <th class="text-center">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($blogs as $blog)
                                <tr>
                                    <th class="text-center align-middle">{{$blog->rank}}</th>
                                    <th class="text-center align-middle">
                                        <img src="{{ asset('public') }}/{{$blog->image}}" alt="image" class="img-fluid img-thumbnail" width="80">
                                    </th>
                                    <td class="align-middle">{{$blog->title_bn}}</td>
                                    <td class="text-center align-middle">
                                        <a href="{{route('blog.edit',$blog->id)}}" class="btn btn-purple btn-sm waves-effect waves-light"><i class="mdi mdi-pencil"></i></a>
                                        <button type="button" class="btn btn-danger btn-sm waves-effect waves-light" data-bs-toggle="modal" data-bs-target="#danger-alert-modal-{{$blog->id}}"><i class="mdi mdi-delete-outline"></i></button>
                                        
                                    </td>
                                </tr>

                                {{-- delete alert --}}
                                <div id="danger-alert-modal-{{$blog->id}}" class="modal fade" tabindex="-1" style="display: none;" aria-hidden="true">
                                    <div class="modal-dialog modal-sm">
                                        <div class="modal-content modal-filled bg-default">
                                            <div class="modal-body">
                                                <div class="text-center">
                                                    <i class="dripicons-wrong h1 text-danger"></i>
                                                    <h3 class="mt-1">Are you sure?</h3>
                                                    <p class="mt-1">You won't be able to revert this!</p>
                                                    <form action="{{route('blog.destroy', $blog->id)}}" method="post" class="d-inline-block">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-purple waves-effect waves-light" data-bs-toggle="modal" data-bs-target="#danger-alert-modal-{{$blog->id}}">Yes, delete it!</button>
                                                    </form>
                                                    <button type="button" class="btn btn-danger waves-effect waves-light my-2" data-bs-dismiss="modal">Cancel</button>
                                                </div>
                                            </div>
                                        </div><!-- /.modal-content -->
                                    </div><!-- /.modal-dialog -->
                                </div>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
               
            </div>
        </div>
    
    </div>
@endsection
@section('script')
    <!-- third party js -->
    <script src="{{asset('backend/assets')}}/libs/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="{{asset('backend/assets')}}/libs/datatables.net-bs5/js/dataTables.bootstrap5.min.js"></script>
    <script src="{{asset('backend/assets')}}/libs/datatables.net-responsive/js/dataTables.responsive.min.js"></script>
    <script src="{{asset('backend/assets')}}/libs/datatables.net-responsive-bs5/js/responsive.bootstrap5.min.js"></script>
    <script src="{{asset('backend/assets')}}/libs/datatables.net-buttons/js/dataTables.buttons.min.js"></script>
    <script src="{{asset('backend/assets')}}/libs/datatables.net-buttons-bs5/js/buttons.bootstrap5.min.js"></script>
    <script src="{{asset('backend/assets')}}/libs/datatables.net-buttons/js/buttons.html5.min.js"></script>
    <script src="{{asset('backend/assets')}}/libs/datatables.net-buttons/js/buttons.flash.min.js"></script>
    <script src="{{asset('backend/assets')}}/libs/datatables.net-buttons/js/buttons.print.min.js"></script>
    <script src="{{asset('backend/assets')}}/libs/datatables.net-keytable/js/dataTables.keyTable.min.js"></script>
    <script src="{{asset('backend/assets')}}/libs/datatables.net-select/js/dataTables.select.min.js"></script>
    <script src="{{asset('backend/assets')}}/libs/pdfmake/build/pdfmake.min.js"></script>
    <script src="{{asset('backend/assets')}}/libs/pdfmake/build/vfs_fonts.js"></script>
    <!-- third party js ends -->

    <!-- Datatables init -->
    <script src="{{asset('backend/assets')}}/js/pages/datatables.init.js"></script>
@endsection
