<?php

namespace App\Image;

use File;
use Intervention\Image\Facades\Image;
use Illuminate\Database\Eloquent\Model;

class ImageUpload extends Model
{
    /**
     * @param $imageName
     * @param array $size
     * @param null $folderName
     * @param null $year
     * @return null|string
     */
    public static function uploadImage($request,$imageName, array $size, $folderName = null, $year = null)
    {
        if ($request->hasFile($imageName)) {
            $toUploadName = hexdec(uniqid()) . $request->file($imageName)->getClientOriginalName();

            $path = $folderName ? 'img/' . $folderName : 'img/' . ($year ?? date('Y'));

            File::makeDirectory($path, $mode = 0777, true, true);
            Image::make($request->file($imageName)->getRealPath())->resize($size[0], $size[1])->save("public/$path/$toUploadName");
            return $path . '/' . $toUploadName;
        }
        return null;
    }
    public static function uploadImageWithoutSize($request,$imageName, $folderName = null, $year = null)
    {
        if ($request->hasFile($imageName)) {
            $toUploadName = hexdec(uniqid()) . $request->file($imageName)->getClientOriginalName();

            $path = $folderName ? 'img/' . $folderName : 'img/' . ($year ?? date('Y'));

            File::makeDirectory($path, $mode = 0777, true, true);
            Image::make($request->file($imageName)->getRealPath())->save("public/$path/$toUploadName");
            return $path . '/' . $toUploadName;
        }
        return null;
    }
}
