<?php

namespace App\Http\Controllers;

use App\Models\MissionVisions;
use Illuminate\Http\Request;
use App\Image\ImageUpload;

class MissionVisionsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('backend.pages.mission_visions.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $image = ImageUpload::uploadImageWithoutSize($request,'image');
        if($image == null)
        {
            $image = MissionVisions::where('id','>',0)->first()->image;
        }
        MissionVisions::where('id','>',0)->update([
            'image' => $image,
            'title' => $request->title,
            'title_bn' => $request->title_bn,
            'vision_bn' => $request->vision_bn,
            'vision' => $request->vision,
            'meta_title' => $request->meta_title,
            'meta_des' => $request->meta_des,
        ]);
        session()->flash('message', 'Mission & Visions save successfully');
        return redirect('admin/mission-visions');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\MissionVisions  $missionVisions
     * @return \Illuminate\Http\Response
     */
    public function show(MissionVisions $missionVisions)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\MissionVisions  $missionVisions
     * @return \Illuminate\Http\Response
     */
    public function edit(MissionVisions $missionVisions)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\MissionVisions  $missionVisions
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, MissionVisions $missionVisions)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\MissionVisions  $missionVisions
     * @return \Illuminate\Http\Response
     */
    public function destroy(MissionVisions $missionVisions)
    {
        //
    }
}
