<?php

namespace App\Http\Controllers;

use App\Models\Gallery;
use App\Image\ImageUpload;
use Illuminate\Http\Request;

class GalleryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $galleries = Gallery::orderBy('rank','ASC')->get();
        return view('backend.pages.gallery.index',compact('galleries'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.pages.gallery.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $image = ImageUpload::uploadImageWithoutSize($request,'image');
        if($image == null)
        {
            session()->flash('error', 'Gallery Image must be required');
            return redirect()->back();
        }
        Gallery::create([
            'image' => $image,
            'title' => $request->title,
            'title_bn' => $request->title_bn,
            'rank' => $request->rank,
        ]);
        session()->flash('message', 'Gallery image added successfully');
        return redirect('admin/gallery');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function show(Gallery $gallery)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function edit(Gallery $gallery)
    {
        return view('backend.pages.gallery.edit',['data' => $gallery]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Gallery $gallery)
    {
        $image = ImageUpload::uploadImageWithoutSize($request,'image');
        if($image == null)
        {
            $image = Gallery::where('id',$gallery->id)->first()->image;
        }
        Gallery::where('id',$gallery->id)->update([
            'image' => $image,
            'title' => $request->title,
            'title_bn' => $request->title_bn,
            'rank' => $request->rank,
        ]);
        session()->flash('message', 'Gallery image updated successfully');
        return redirect('admin/gallery');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function destroy(Gallery $gallery)
    {
        $gallery->delete();
        session()->flash('message', 'Gallery image delete successfully');
        return redirect('admin/gallery');
    }
}
