<?php

namespace App\Http\Controllers;

use App\Models\FounderSpeech;
use Illuminate\Http\Request;
use App\Image\ImageUpload;

class FounderSpeechController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('backend.pages.founder_speech.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $image = ImageUpload::uploadImageWithoutSize($request,'image');
        if($image == null)
        {
            $image = FounderSpeech::where('id','>',0)->first()->image;
        }
        FounderSpeech::where('id','>',0)->update([
            'image' => $image,
            'title' => $request->title,
            'title_bn' => $request->title_bn,
            'name' => $request->name,
            'name_bn' => $request->name_bn,
            'designation' => $request->designation,
            'designation_bn' => $request->designation_bn,
            'speech' => $request->speech,
            'speech_bn' => $request->speech_bn,
            'meta_title' => $request->meta_title,
            'meta_des' => $request->meta_des,
        ]);
        session()->flash('message', 'Founder Speech save successfully');
        return redirect('admin/founder-speech');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\FounderSpeech  $founderSpeech
     * @return \Illuminate\Http\Response
     */
    public function show(FounderSpeech $founderSpeech)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\FounderSpeech  $founderSpeech
     * @return \Illuminate\Http\Response
     */
    public function edit(FounderSpeech $founderSpeech)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\FounderSpeech  $founderSpeech
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, FounderSpeech $founderSpeech)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\FounderSpeech  $founderSpeech
     * @return \Illuminate\Http\Response
     */
    public function destroy(FounderSpeech $founderSpeech)
    {
        //
    }
}
