<?php

namespace App\Http\Controllers;

use App\Models\Company;
use App\Image\ImageUpload;
use Illuminate\Http\Request;

class CompanyController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('backend.pages.setting.company.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $image = ImageUpload::uploadImageWithoutSize($request,'image');
        if($image == null)
        {
            $image = Company::where('id','>',0)->first()->logo;
        }
        $favicon = ImageUpload::uploadImageWithoutSize($request,'favicon');
        if($favicon == null)
        {
            $favicon = Company::where('id','>',0)->first()->favicon;
        }
        Company::where('id','>',0)->update([
            'logo' => $image,
            'favicon' => $favicon,
            'name' => $request->name,
            'name_bn' => $request->name_bn,
            'email' => $request->email,
            'phone' => $request->phone,
            'phone_bn' => $request->phone_bn,
            'address' => $request->address,
            'address_bn' => $request->address_bn,
            'meta_title' => $request->meta_title,
            'meta_des' => $request->meta_des,
            'google_maps' => $request->google_maps
        ]);
        session()->flash('message', 'Company profile save successfully');
        return redirect('admin/company');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Company  $company
     * @return \Illuminate\Http\Response
     */
    public function show(Company $company)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Company  $company
     * @return \Illuminate\Http\Response
     */
    public function edit(Company $company)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Company  $company
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Company $company)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Company  $company
     * @return \Illuminate\Http\Response
     */
    public function destroy(Company $company)
    {
        //
    }
}
