<?php

namespace App\Http\Controllers;

use App\Models\Blog;
use App\Image\ImageUpload;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class BlogController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $blogs = Blog::orderBy('rank','ASC')->get();
        return view('backend.pages.blog.index',compact('blogs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.pages.blog.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $image = ImageUpload::uploadImageWithoutSize($request,'image');
        if($image == null)
        {
            session()->flash('error', 'Blog Image must be required');
            return redirect()->back();
        }
        Blog::create([
            'image' => $image,
            'title' => $request->title,
            'title_bn' => $request->title_bn,
            'slug' => Str::slug($request->title),
            'description' => $request->description,
            'description_bn' => $request->description_bn,
            'meta_title' => $request->meta_title,
            'meta_des' => $request->meta_des,
            'rank' => $request->rank,
        ]);
        session()->flash('message', 'Blog create successfully');
        return redirect('admin/blog');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function show(Blog $blog)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function edit(Blog $blog)
    {
        return view('backend.pages.blog.edit',['blog' => $blog]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Blog $blog)
    {
        $image = ImageUpload::uploadImageWithoutSize($request,'image');
        if($image == null)
        {
            $image = Blog::where('id',$blog->id)->first()->image;
        }
        Blog::where('id',$blog->id)->update([
            'image' => $image,
            'title' => $request->title,
            'title_bn' => $request->title_bn,
            'slug' => Str::slug($request->title),
            'description' => $request->description,
            'description_bn' => $request->description_bn,
            'meta_title' => $request->meta_title,
            'meta_des' => $request->meta_des,
            'rank' => $request->rank,
        ]);
        session()->flash('message', 'Blog update successfully');
        return redirect('admin/blog');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Blog  $blog
     * @return \Illuminate\Http\Response
     */
    public function destroy(Blog $blog)
    {
        $blog->delete();
        session()->flash('message', 'Blog delete successfully');
        return redirect()->back();
    }
}
