<?php

namespace App\Http\Controllers;

use App\Models\AboutUs;
use App\Image\ImageUpload;
use Illuminate\Http\Request;

class AboutUsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('backend.pages.about_us.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       
        $image = ImageUpload::uploadImageWithoutSize($request,'image');
        if($image == null)
        {
            $image = AboutUs::where('id','>',0)->first()->image;
        }
        AboutUs::where('id','>',0)->update([
            'image' => $image,
            'title' => $request->title,
            'title_bn' => $request->title_bn,
            'short_description_bn' => $request->short_description_bn,
            'short_description' => $request->short_description,
            'description_bn' => $request->description_bn,
            'description' => $request->description,
            'meta_title' => $request->meta_title,
            'meta_des' => $request->meta_des,
        ]);
        session()->flash('message', 'About Us save successfully');
        return redirect('admin/about');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\AboutUs  $aboutUs
     * @return \Illuminate\Http\Response
     */
    public function show(AboutUs $aboutUs)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\AboutUs  $aboutUs
     * @return \Illuminate\Http\Response
     */
    public function edit(AboutUs $aboutUs)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\AboutUs  $aboutUs
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, AboutUs $aboutUs)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\AboutUs  $aboutUs
     * @return \Illuminate\Http\Response
     */
    public function destroy(AboutUs $aboutUs)
    {
        //
    }
}
