<?php 
session_start();
include('../inc/dbcon.php');
include('../inc/functions.php');
include('../inc/invfunctions.php');

use Dompdf\Dompdf;
require '../vendor/autoload.php'; // adjust path if needed

if (!isset($_SESSION["axeslogin"]) || $_SESSION["axeslogin"] != true) {
    header('Location:../index.php');
    exit;
}

if (!isset($_POST['print'])) {
    die("No invoice selected.");
}

$invid = $_POST['print']; // ✅ corrected line
$sql = "SELECT * FROM tbl_recvoucher WHERE id='" . mysqli_real_escape_string($con, $invid) . "' LIMIT 1";
$query = mysqli_query($con, $sql) or die(mysqli_error($con));
$rowadd = mysqli_fetch_array($query);

$id = $rowadd['id']; // Now this should work as expected

$user = get_fild_data('tbl_user', $rowadd['uid'], 'name');

// Start HTML
ob_start();
?>

<div id="invoice">
  <style>
    body {
      font-family: Arial, sans-serif;
      font-size: 13px;
      color: #333;
      background: #fff;
    }
    #invoice {
      width: 700px;
      margin: 0 auto;
      padding: 20px;
      border: 1px solid #ddd;
    }
    .header {
      display: flex;
      justify-content: space-between;
      border-bottom: 2px solid #3785B1;
      padding-bottom: 10px;
      margin-bottom: 15px;
    }
    /*.header img {*/
    /*  max-height: 70px;*/
    /*}*/
    .header .company-info {
      text-align: right;
    }
    h2 {
      text-align: center;
      color: #3785B1;
      margin: 0 0 15px;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-bottom: 15px;
    }
    th, td {
      border: 1px solid #ddd;
      padding: 6px 8px;
      text-align: center;
    }
    th {
      background: #f2f2f2;
    }
    tfoot td {
      font-weight: bold;
    }
    .note, .footer {
      margin-top: 10px;
      font-size: 12px;
    }
    .footer {
      text-align: right;
      margin-top: 40px;
    }
  </style>

  <div class="header">
    <!--<div class="logo">-->
    <!--  <img src="../img/<?php echo empty(get_cominfo('1','logo')) ? 'no_logo.png' : get_cominfo('1','logo'); ?>" alt="Logo">-->
    <!--</div>-->
    <div class="company-info">
      <strong><?php echo get_cominfo('1','name'); ?></strong><br>
      <?php echo get_cominfo('1'); ?><br>
      <strong>Receipt No:</strong> <?php echo $rowadd['invno']; ?><br>
      <strong>Date:</strong> <?php echo date("d M Y", strtotime($rowadd['apdate'])); ?>
    </div>
  </div>

  <h2>Receipt Voucher</h2>

  <table>
    <thead>
      <tr>
        <th>No</th>
        <th>Head of Accounts</th>
        <th>Mode</th>
        <th>Cheque</th>
        <th>Date</th>
        <th>Amount</th>
        <th>Reference</th>
      </tr>
    </thead>
    <tbody>
      <?php    
        $sql="SELECT (CONVERT(CONCAT(tbl_recvoucherde.cty,tbl_recvoucherde.cid) USING utf8) COLLATE utf8_general_ci) AS id,did,dty,amount as amo,cheno as chkno,chedt as chkdt,ref FROM tbl_recvoucherde WHERE seid='".$rowadd['id']."'";
        $querys=mysqli_query($con,$sql);
        $sl=1;
        while ($rows=mysqli_fetch_array($querys)){    
      ?>
      <tr>
        <td><?php echo $sl++; ?></td>
        <td><?php echo get_fild_data('tbl_ledger',$rows['id'],'ledger'); ?></td>
        <td><?php echo get_namebytype($rows['dty'],'N',$rows['did']); ?></td>
        <td><?php echo $rows['chkno']; ?></td>
        <td><?php echo !empty($rows['chkno']) ? date("d M Y", strtotime($rows['chkdt'])) : ''; ?></td>
        <td style="text-align:right;"><?php echo numtolocal($rows['amo'],''); ?></td>
        <td><?php echo $rows['ref']; ?></td>
      </tr>
      <?php } ?>  
    </tbody>
    <tfoot>
      <tr>
        <td colspan="5" style="text-align:right;">Total:</td>
        <td style="text-align:right;"><?php echo numtolocal($rowadd['amount'],''); ?></td>
        <td></td>
      </tr>
    </tfoot>
  </table>

  <div class="note">
    <strong>In Word:</strong> <?php echo conToword_local($rowadd['amount']).'.'; ?><br>
    <strong>Note:</strong> <?php echo $rowadd['note']; ?>
  </div>

  <div class="footer">
    <p>Received By: <strong><?php echo $user; ?></strong></p>
  </div>
</div>

<?php
$html = ob_get_clean();

// Initialize Dompdf
$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

// Output the generated PDF to browser
$dompdf->stream("receipt_voucher_" . $rowadd['invno'] . ".pdf", [
    "Attachment" => true // change to true to force download
]);
exit;
?>