<?php
session_start();
require_once '../inc/dbcon.php';
require_once '../inc/functions.php';

// Must be logged in
if(!isset($_SESSION["axeslogin"]) || $_SESSION["axeslogin"] != true){
    header("location:../index.php");
    exit;
}

// Only admin (utype=1) can access this page
if(!isset($_SESSION['utype']) || (int)$_SESSION['utype'] !== 1){
    // Non-admin shouldn't select branch
    header("location:home.php");
    exit;
}

// Load branches
$branches = [];
$res = mysqli_query($con, "SELECT id, name FROM tbl_branch ORDER BY name ASC");
if($res){
    while($r = mysqli_fetch_assoc($res)){
        $branches[] = $r;
    }
}

// If posted, save selection
if(isset($_POST['branch_id']) && $_POST['branch_id'] != ''){
    $branch_id = (int)$_POST['branch_id'];

    // Validate branch exists
    $chk = mysqli_query($con, "SELECT id, name FROM tbl_branch WHERE id=$branch_id LIMIT 1");
    if($chk && mysqli_num_rows($chk) == 1){
        $b = mysqli_fetch_assoc($chk);

        $_SESSION['branch_id'] = (int)$b['id'];
        $_SESSION['branch_name'] = $b['name'];
        $_SESSION['abrid']  = (int)$b['id'];

        // Now go to the cuPages (default home.php)
        if(!isset($_SESSION['cuPages']) || $_SESSION['cuPages'] == ''){
            $_SESSION['cuPages'] = "home.php";
        }
        header("location:".$_SESSION['cuPages']);
        exit;
    } else {
        $_SESSION['abrid']  = 0;
        if(!isset($_SESSION['cuPages']) || $_SESSION['cuPages'] == ''){
            $_SESSION['cuPages'] = "home.php";
        }
        header("location:".$_SESSION['cuPages']);
        exit;
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Select Branch</title>
    <link rel="stylesheet" href="../css/bootstrap.min.css">
</head>
<body style="background:#f5f5f5;">
<div class="container" style="max-width:500px;margin-top:80px;">
    <div class="panel panel-default">
        <div class="panel-heading"><b>Select Branch</b></div>
        <div class="panel-body">

            <?php if(!empty($err)){ ?>
                <p class="text-danger"><?php echo $err; ?></p>
            <?php } ?>

            <form method="post">
                <div class="form-group">
                    <label>Choose Branch</label>
                    <select name="branch_id" class="form-control" required>
                        <option value="">-- Select --</option>
                        <option value="0">-- Main Branch --</option>
                        <?php foreach($branches as $br){ ?>
                            <option value="<?php echo (int)$br['id']; ?>">
                                <?php echo htmlspecialchars($br['name']); ?>
                            </option>
                        <?php } ?>
                    </select>
                </div>

                <button type="submit" class="btn btn-primary">Continue</button>
            </form>

        </div>
    </div>
</div>
</body>
</html>