<?php
session_start();
include('dbcon.php');
include('functions.php');

$today = strftime("%Y-%m-%d", time());

// Validate input
if (!isset($_POST['email']) || !isset($_POST['password']) || $_POST['email'] == '' || $_POST['password'] == '') {
    header("location:../index.php");
    exit;
}

$uname = $_POST['email'];
$passw = sha1($_POST['password']);

// Check user
$sql = "SELECT * FROM tbl_user WHERE email='$uname' AND password='$passw' LIMIT 1";
$res = mysqli_query($con, $sql);

if (!$res) {
    // Query failed
    $_SESSION['errmsg'] = 'Server error. Please try again.';
    $_SESSION['uid'] = 0;
    $_SESSION['axeslogin'] = false;
    header("location:../index.php");
    exit;
}

$row   = mysqli_fetch_array($res);
$count = mysqli_num_rows($res);

// Wrong login
if ($count <= 0) {
    if (get_fild_data('tbl_setting', '1', 'sval') == 0) {
        $_SESSION['errmsg'] = 'You enter wrong user name or password!';
    } else {
        $_SESSION['errmsg'] = 'আপনি  নাম অথবা পাসওয়ার্ড ভুল করেছেন!';
    }

    $_SESSION['uid'] = 0;
    $_SESSION['axeslogin'] = false;
    header("location:../index.php");
    exit;
}

// Validity / expiry check
if ($today >= get_fild_data('tbl_limitset', '1', 'expDate')) {
    if (get_fild_data('tbl_setting', '1', 'sval') == 0) {
        $_SESSION['errmsg'] = 'Your Validity Period was Expired!';
    } else {
        $_SESSION['errmsg'] = 'আপনার বৈধতার মেয়াদ শেষ হয়ে গেছে!';
    }

    $_SESSION['uid'] = 0;
    $_SESSION['axeslogin'] = false;
    header("location:../index.php");
    exit;
}

/**
 * SUCCESS LOGIN
 * Set all existing sessions like your old code
 */
$_SESSION['axeslogin'] = true;
$_SESSION['utype']     = $row['utype'];
$_SESSION['avname']    = $row['name'];

if (get_fild_data('tbl_setting', '1', 'sval') == 0) {
    $_SESSION['exname'] = $row['name'];
} else {
    $_SESSION['exname'] = $row['bname'];
}

$_SESSION['access'] = $row['acess'];   // keeping your column name "acess"
$_SESSION['uimage'] = $row['image'];
$_SESSION['uid']    = $row['id'];
$_SESSION['abrid']  = $row['abrid'];

// default page
if (!isset($_SESSION['cuPages']) || $_SESSION['cuPages'] == '') {
    $_SESSION['cuPages'] = "home.php";
}

// Write activity log
write_activity($_SESSION['uid'], 'LOG', 'Login Record', 'Successfully login.', 'লগইন রেকর্ড', 'প্রবেশ সফল হয়েছে।');


/**
 * BRANCH LOGIC
 * - Admin (utype==1): must choose branch (tbl_branch) before entering
 * - Others: auto-set branch session from user's abrid
 */
if ((int)$_SESSION['utype'] === 1) {

    // Check how many branches exist
    $branchCheck = mysqli_query($con, "SELECT COUNT(*) as total FROM tbl_branch");
    $branchData  = mysqli_fetch_assoc($branchCheck);
    $totalBranch = (int)$branchData['total'];

    // If no branch exists in table → direct login
    if ($totalBranch <= 0) {

        header("location:../pages/" . $_SESSION['cuPages']);
        exit;

    } else {

        // If admin has not selected branch yet → go to select page
        if (!isset($_SESSION['branch_id']) || (int)$_SESSION['branch_id'] <= 0) {
            header("location:../pages/select_branch.php");
            exit;
        }

        // If already selected → continue
        header("location:../pages/" . $_SESSION['cuPages']);
        exit;
    }

} else {

    // Non-admin: fixed branch (own abrid)
    $_SESSION['branch_id'] = (int)$_SESSION['abrid'];

    header("location:../pages/" . $_SESSION['cuPages']);
    exit;
}
?>