<?php 

$botToken = '8530314009:AAFqoOncfvFzL1MBNuKsgFyLTg-VoXPevIs';
$chatId   = '8087456967';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

$name     = isset($_POST['name']) ? trim($_POST['name']) : '';
$phone    = isset($_POST['phone']) ? trim($_POST['phone']) : '';
$datetime = isset($_POST['datetime']) ? trim($_POST['datetime']) : '';

if ($name === '' || $phone === '' || $datetime === '') {
    http_response_code(200);
    echo json_encode(['success' => false, 'message' => 'Please fill in all fields.']);
    exit;
}

$preferred = $datetime;
if ($datetime !== '') {
    $dtObj = date_create($datetime);
    if ($dtObj) {
        $preferred = $dtObj->format('M d, Y h:i A');
    }
}

$messageLines = [
    "New appointment request from Axesba:",
    "Name: {$name}",
    "Phone: {$phone}",
    "Preferred Time: {$preferred}"
];
$messageText = implode("\n", $messageLines);

$telegramUrl = "https://api.telegram.org/bot{$botToken}/sendMessage";

$postFields = [
    'chat_id' => $chatId,
    'text'    => $messageText
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $telegramUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$response = curl_exec($ch);
$curlError = curl_error($ch);
$httpCode  = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($response === false || $curlError) {
    http_response_code(200);
    echo json_encode(['success' => false, 'message' => 'Unable to contact Telegram API.']);
    exit;
}

$decoded = json_decode($response, true);

if ($httpCode === 200 && isset($decoded['ok']) && $decoded['ok']) {
    echo json_encode(['success' => true, 'message' => 'Appointment request sent successfully!']);
} else {
    http_response_code(200);
    $errorDesc = isset($decoded['description']) ? $decoded['description'] : 'Unknown error from Telegram.';
    echo json_encode(['success' => false, 'message' => 'Telegram error: ' . $errorDesc]);
}