<?php
session_start();
include('../inc/dbcon.php');
include('../inc/functions.php');
include('../inc/invfunctions.php');

use Dompdf\Dompdf;
require '../vendor/autoload.php'; // adjust path if needed

if(!isset($_SESSION["axeslogin"]) || $_SESSION["axeslogin"] != true){
    header('Location:../index.php');
    exit;
}

if(!isset($_POST['print'])) {
    die("No invoice selected.");
}

$invid = $_POST['print'];
$sql = "SELECT * FROM tbl_recvoucher WHERE id='".$invid."' LIMIT 1";
$query = mysqli_query($con, $sql) or die(mysqli_error($con));
$rowadd = mysqli_fetch_array($query);
$id = $rowadd['id'];

$user = get_fild_data('tbl_user', $rowadd['uid'], 'name');

// Start HTML
ob_start();
?>
<html>
<head>
    <meta charset="UTF-8">
    <title>Receipt Voucher</title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; color: #2e2e2e; }
        h3 { color: #009be1; text-align: center; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { border: 1px solid #ddd; padding: 5px; text-align: left; }
        th { background: #f2f2f2; }
        .text-right { text-align: right; }
        .footer { text-align: center; font-size: 10px; margin-top: 30px; color: #666; }
    </style>
</head>
<body>

<h3>RECEIPT VOUCHER</h3>
<p><b>Receipt No:</b> <?= $rowadd['invno']; ?><br>
<b>Date:</b> <?= date("d M Y", strtotime($rowadd['apdate'])); ?></p>

<table>
<thead>
<tr>
<th>N°</th>
<th>Head of Accounts</th>
<th>Mode</th>
<th>Cheque</th>
<th>Date</th>
<th class="text-right">Amount</th>
<th>Reference</th>
</tr>
</thead>
<tbody>
<?php    
$sql="SELECT (CONVERT(CONCAT(tbl_trarecord.cty,tbl_trarecord.cid) USING utf8) COLLATE utf8_general_ci) AS id,
did,dty,amo,chkno,chkdt,ref,refinv FROM tbl_trarecord WHERE invno='".$rowadd['invno']."'";
$querys=mysqli_query($con,$sql)or die(mysqli_error($con));
$count=1;
while ($rows=mysqli_fetch_array($querys)){    
?>
<tr>
<td><?= $count++; ?></td>
<td><?= get_fild_data('tbl_ledger',$rows['id'],'ledger'); ?></td>
<td><?= get_namebytype($rows['dty'],'N',$rows['did']); ?></td>
<td><?= $rows['chkno']; ?></td>
<td><?= (strlen($rows['chkno'])>0) ? date("d M Y", strtotime($rows['chkdt'])) : ''; ?></td>
<td class="text-right"><?= numtolocal($rows['amo'],''); ?></td> 
<td><?= $rows['ref'].' '.$rows['refinv']; ?></td> 
</tr>    
<?php } ?>        
</tbody>
<tfoot>
<tr>
<td colspan="5" class="text-right"><b>Total</b></td>
<td class="text-right"><b><?= numtolocal($rowadd['amount'],''); ?></b></td>
<td></td>
</tr>
<tr>
<td colspan="7"><b>In Word:</b> <?= conToword_local($rowadd['amount']).'.'; ?></td>
</tr>
<tr>
<td colspan="7"><b>Note:</b> <?= $rowadd['note']; ?></td>
</tr>
</tfoot>    
</table>

<div class="footer">
<p>Authorized Signature</p>
<hr style="width:150px;">
<p><?= get_cominfo('1','name'); ?> © 2020</p>
</div>

</body>
</html>
<?php
$html = ob_get_clean();

// Initialize DOMPDF
$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("receipt_".$rowadd['invno'].".pdf", array("Attachment" => false));
exit;
?>
